/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.queryable;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.shardingsphere.dbdiscovery.yaml.config.YamlDatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.yaml.config.rule.YamlDatabaseDiscoveryDataSourceRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.yaml.config.rule.YamlDatabaseDiscoveryHeartBeatConfiguration;
import org.apache.shardingsphere.distsql.parser.statement.ral.queryable.ConvertYamlConfigurationStatement;
import org.apache.shardingsphere.encrypt.yaml.config.YamlEncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.config.rule.YamlEncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.yaml.config.rule.YamlEncryptTableRuleConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.datasource.config.DataSourceConfiguration;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesCreator;
import org.apache.shardingsphere.infra.datasource.props.custom.CustomDataSourceProperties;
import org.apache.shardingsphere.infra.datasource.props.synonym.PoolPropertySynonyms;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.pojo.algorithm.YamlAlgorithmConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyDataSourceConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyDatabaseConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.swapper.YamlProxyDataSourceConfigurationSwapper;
import org.apache.shardingsphere.proxy.backend.exception.FileIOException;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.QueryableRALBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.common.constant.DistSQLScriptConstants;
import org.apache.shardingsphere.readwritesplitting.yaml.config.YamlReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.yaml.config.rule.YamlReadwriteSplittingDataSourceRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.yaml.config.strategy.YamlStaticReadwriteSplittingStrategyConfiguration;
import org.apache.shardingsphere.shadow.yaml.config.YamlShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.yaml.config.datasource.YamlShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.yaml.config.table.YamlShadowTableConfiguration;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.keygen.KeyGenerateStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.yaml.config.YamlShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.swapper.YamlShardingRuleConfigurationSwapper;

public final class ConvertYamlConfigurationHandler
extends QueryableRALBackendHandler<ConvertYamlConfigurationStatement> {
    private final YamlProxyDataSourceConfigurationSwapper dataSourceConfigSwapper = new YamlProxyDataSourceConfigurationSwapper();

    @Override
    protected Collection<String> getColumnNames() {
        return Collections.singleton("distsql");
    }

    @Override
    protected Collection<LocalDataQueryResultRow> getRows(ContextManager contextManager) {
        YamlProxyDatabaseConfiguration yamlConfig;
        File file = new File(((ConvertYamlConfigurationStatement)this.getSqlStatement()).getFilePath());
        try {
            yamlConfig = (YamlProxyDatabaseConfiguration)YamlEngine.unmarshal((File)file, YamlProxyDatabaseConfiguration.class);
        }
        catch (IOException ex) {
            throw new FileIOException(ex);
        }
        Preconditions.checkNotNull((Object)yamlConfig, (String)"Invalid yaml file `%s`", (Object)file.getName());
        Preconditions.checkNotNull((Object)yamlConfig.getDatabaseName(), (String)"`databaseName` in file `%s` is required.", (Object)file.getName());
        return Collections.singleton(new LocalDataQueryResultRow(new Object[]{this.generateDistSQL(yamlConfig)}));
    }

    private String generateDistSQL(YamlProxyDatabaseConfiguration yamlConfig) {
        String databaseType;
        StringBuilder result = new StringBuilder();
        switch (databaseType = yamlConfig.getDatabaseName()) {
            case "resource_db": {
                this.addResourceDistSQL(yamlConfig, result);
                break;
            }
            case "sharding_db": {
                this.addShardingDistSQL(yamlConfig, result);
                break;
            }
            case "readwrite_splitting_db": {
                this.addReadWriteSplittingDistSQL(yamlConfig, result);
                break;
            }
            case "database_discovery_db": {
                this.addDatabaseDiscoveryDistSQL(yamlConfig, result);
                break;
            }
            case "encrypt_db": {
                this.addEncryptDistSQL(yamlConfig, result);
                break;
            }
            case "shadow_db": {
                this.addShadowDistSQL(yamlConfig, result);
                break;
            }
        }
        return result.toString();
    }

    private void addResourceDistSQL(YamlProxyDatabaseConfiguration yamlConfig, StringBuilder result) {
        this.appendDatabase(yamlConfig.getDatabaseName(), result);
        this.appendResources(yamlConfig.getDataSources(), result);
    }

    private void addShardingDistSQL(YamlProxyDatabaseConfiguration yamlConfig, StringBuilder result) {
        this.appendDatabase(yamlConfig.getDatabaseName(), result);
        this.appendResources(yamlConfig.getDataSources(), result);
        this.appendShardingRules(yamlConfig.getRules(), result);
    }

    private void addReadWriteSplittingDistSQL(YamlProxyDatabaseConfiguration yamlConfig, StringBuilder result) {
        this.appendDatabase(yamlConfig.getDatabaseName(), result);
        this.appendResources(yamlConfig.getDataSources(), result);
        this.appendReadWriteSplittingRules(yamlConfig.getRules(), result);
    }

    private void addDatabaseDiscoveryDistSQL(YamlProxyDatabaseConfiguration yamlConfig, StringBuilder result) {
        this.appendDatabase(yamlConfig.getDatabaseName(), result);
        this.appendResources(yamlConfig.getDataSources(), result);
        this.appendDatabaseDiscoveryRules(yamlConfig.getRules(), result);
    }

    private void addEncryptDistSQL(YamlProxyDatabaseConfiguration yamlConfig, StringBuilder result) {
        this.appendDatabase(yamlConfig.getDatabaseName(), result);
        this.appendResources(yamlConfig.getDataSources(), result);
        this.appendEncryptRules(yamlConfig.getRules(), result);
    }

    private void addShadowDistSQL(YamlProxyDatabaseConfiguration yamlConfig, StringBuilder result) {
        this.appendDatabase(yamlConfig.getDatabaseName(), result);
        this.appendResources(yamlConfig.getDataSources(), result);
        this.appendShadowRules(yamlConfig.getRules(), result);
    }

    private void appendDatabase(String databaseName, StringBuilder result) {
        result.append(String.format("CREATE DATABASE %s;", databaseName)).append(System.lineSeparator());
        result.append(String.format("USE %s;", databaseName)).append(System.lineSeparator());
    }

    private void appendResources(Map<String, YamlProxyDataSourceConfiguration> dataSources, StringBuilder result) {
        if (dataSources.isEmpty()) {
            return;
        }
        result.append("ADD RESOURCE");
        Iterator<Map.Entry<String, YamlProxyDataSourceConfiguration>> iterator = dataSources.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, YamlProxyDataSourceConfiguration> entry = iterator.next();
            DataSourceProperties dataSourceProperties = DataSourcePropertiesCreator.create((String)HikariDataSource.class.getName(), (DataSourceConfiguration)this.dataSourceConfigSwapper.swap(entry.getValue()));
            this.appendResource(entry.getKey(), dataSourceProperties, result);
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        result.append(";").append(System.lineSeparator());
    }

    private void appendResource(String resourceName, DataSourceProperties dataSourceProperties, StringBuilder result) {
        Map connectionProperties = dataSourceProperties.getConnectionPropertySynonyms().getStandardProperties();
        String url = (String)connectionProperties.get("url");
        String username = (String)connectionProperties.get("username");
        String password = (String)connectionProperties.get("password");
        String props = this.getResourceProperties(dataSourceProperties.getPoolPropertySynonyms(), dataSourceProperties.getCustomDataSourceProperties());
        if (Strings.isNullOrEmpty((String)password)) {
            result.append(String.format(DistSQLScriptConstants.RESOURCE_DEFINITION_WITHOUT_PASSWORD, resourceName, url, username, props));
        } else {
            result.append(String.format(DistSQLScriptConstants.RESOURCE_DEFINITION, resourceName, url, username, password, props));
        }
    }

    private String getResourceProperties(PoolPropertySynonyms poolPropertySynonyms, CustomDataSourceProperties customDataSourceProperties) {
        StringBuilder result = new StringBuilder();
        this.appendProperties(poolPropertySynonyms.getStandardProperties(), result);
        if (!customDataSourceProperties.getProperties().isEmpty()) {
            result.append(",");
            this.appendProperties(customDataSourceProperties.getProperties(), result);
        }
        return result.toString();
    }

    private void appendProperties(Map<String, Object> properties, StringBuilder stringBuilder) {
        Iterator<Map.Entry<String, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            if (null == entry.getValue()) continue;
            stringBuilder.append(String.format("\"%s\"=\"%s\"", entry.getKey(), entry.getValue()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
    }

    private void appendShardingRules(Collection<YamlRuleConfiguration> ruleConfigs, StringBuilder result) {
        if (ruleConfigs.isEmpty()) {
            return;
        }
        for (YamlRuleConfiguration ruleConfig : ruleConfigs) {
            ShardingRuleConfiguration shardingRuleConfig = new YamlShardingRuleConfigurationSwapper().swapToObject((YamlShardingRuleConfiguration)ruleConfig);
            this.appendShardingAlgorithms(shardingRuleConfig, result);
            this.appendKeyGenerators(shardingRuleConfig, result);
            this.appendShardingTableRules(shardingRuleConfig, result);
            this.appendShardingBindingTableRules(shardingRuleConfig, result);
            this.appendShardingBroadcastTableRules(shardingRuleConfig, result);
        }
    }

    private void appendShardingAlgorithms(ShardingRuleConfiguration shardingRuleConfig, StringBuilder result) {
        result.append("CREATE SHARDING ALGORITHM");
        Iterator iterator = shardingRuleConfig.getShardingAlgorithms().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String shardingAlgorithmName = (String)entry.getKey();
            String algorithmType = ((AlgorithmConfiguration)entry.getValue()).getType().toLowerCase();
            String property = this.appendShardingAlgorithmProperties(((AlgorithmConfiguration)entry.getValue()).getProps());
            result.append(String.format(DistSQLScriptConstants.SHARDING_ALGORITHM, shardingAlgorithmName, algorithmType, property));
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        result.append(";").append(System.lineSeparator());
    }

    private String appendShardingAlgorithmProperties(Properties property) {
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<Object, Object>> iterator = property.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            result.append(String.format("\"%s\"=\"%s\"", entry.getKey(), entry.getValue()));
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    private void appendKeyGenerators(ShardingRuleConfiguration shardingRuleConfig, StringBuilder result) {
        result.append("CREATE SHARDING KEY GENERATOR");
        Iterator iterator = shardingRuleConfig.getKeyGenerators().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String generatorName = (String)entry.getKey();
            String type = ((AlgorithmConfiguration)entry.getValue()).getType();
            result.append(String.format(DistSQLScriptConstants.KEY_GENERATOR, generatorName, type));
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        result.append(";").append(System.lineSeparator());
    }

    private void appendShardingTableRules(ShardingRuleConfiguration shardingRuleConfig, StringBuilder result) {
        result.append("CREATE SHARDING TABLE RULE");
        Iterator iterator = shardingRuleConfig.getTables().iterator();
        while (iterator.hasNext()) {
            ShardingTableRuleConfiguration entry = (ShardingTableRuleConfiguration)iterator.next();
            String tableName = entry.getLogicTable();
            String dataNodes = entry.getActualDataNodes();
            String strategy = this.appendTableStrategy(entry);
            result.append(String.format(DistSQLScriptConstants.SHARDING_TABLE, tableName, dataNodes, strategy));
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        result.append(";").append(System.lineSeparator());
    }

    private String appendTableStrategy(ShardingTableRuleConfiguration shardingTableRuleConfig) {
        StringBuilder result = new StringBuilder();
        if (null != shardingTableRuleConfig.getDatabaseShardingStrategy()) {
            this.getStrategy(shardingTableRuleConfig.getDatabaseShardingStrategy(), "DATABASE_STRATEGY", result);
        }
        if (null != shardingTableRuleConfig.getTableShardingStrategy()) {
            this.getStrategy(shardingTableRuleConfig.getTableShardingStrategy(), "TABLE_STRATEGY", result);
        }
        if (null != shardingTableRuleConfig.getKeyGenerateStrategy()) {
            KeyGenerateStrategyConfiguration keyGenerateStrategyConfig = shardingTableRuleConfig.getKeyGenerateStrategy();
            String column = keyGenerateStrategyConfig.getColumn();
            String keyGenerator = keyGenerateStrategyConfig.getKeyGeneratorName();
            result.append(String.format(DistSQLScriptConstants.KEY_GENERATOR_STRATEGY, column, keyGenerator));
        }
        return result.substring(0, result.lastIndexOf(","));
    }

    private StringBuilder getStrategy(ShardingStrategyConfiguration shardingStrategyConfiguration, String strategyType, StringBuilder result) {
        String type = shardingStrategyConfiguration.getType().toLowerCase();
        String shardingAlgorithmName = shardingStrategyConfiguration.getShardingAlgorithmName();
        switch (type) {
            case "standard": {
                StandardShardingStrategyConfiguration standardShardingStrategyConfig = (StandardShardingStrategyConfiguration)shardingStrategyConfiguration;
                String shardingColumn = standardShardingStrategyConfig.getShardingColumn();
                result.append(String.format(DistSQLScriptConstants.SHARDING_STRATEGY_STANDARD, strategyType, type, shardingColumn, shardingAlgorithmName));
                break;
            }
            case "complex": {
                ComplexShardingStrategyConfiguration complexShardingStrategyConfig = (ComplexShardingStrategyConfiguration)shardingStrategyConfiguration;
                String shardingColumns = complexShardingStrategyConfig.getShardingColumns();
                result.append(String.format(DistSQLScriptConstants.SHARDING_STRATEGY_COMPLEX, strategyType, type, shardingColumns, shardingAlgorithmName));
                break;
            }
            case "hint": {
                result.append(String.format(DistSQLScriptConstants.SHARDING_STRATEGY_HINT, type, shardingAlgorithmName));
                break;
            }
        }
        return result;
    }

    private void appendShardingBindingTableRules(ShardingRuleConfiguration shardingRuleConfig, StringBuilder result) {
        String bindings = this.getBindings(shardingRuleConfig.getBindingTableGroups().iterator());
        result.append(String.format("CREATE SHARDING BINDING TABLE RULES %s", bindings));
    }

    private String getBindings(Iterator<String> iterator) {
        StringBuilder result = new StringBuilder();
        while (iterator.hasNext()) {
            String binding = iterator.next();
            result.append(String.format("(%s)", binding));
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        result.append(";").append(System.lineSeparator());
        return result.toString();
    }

    private void appendShardingBroadcastTableRules(ShardingRuleConfiguration shardingRuleConfig, StringBuilder result) {
        String broadcast = this.getBroadcast(shardingRuleConfig.getBroadcastTables().iterator());
        result.append(String.format("CREATE SHARDING BROADCAST TABLE RULES %s", broadcast));
    }

    private String getBroadcast(Iterator<String> iterator) {
        StringBuilder result = new StringBuilder();
        while (iterator.hasNext()) {
            String broadcast = iterator.next();
            result.append(String.format("(%s)", broadcast));
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        result.append(";").append(System.lineSeparator());
        return result.toString();
    }

    private void appendReadWriteSplittingRules(Collection<YamlRuleConfiguration> ruleConfigs, StringBuilder result) {
        if (ruleConfigs.isEmpty()) {
            return;
        }
        result.append("CREATE READWRITE_SPLITTING RULE");
        for (YamlRuleConfiguration ruleConfig : ruleConfigs) {
            this.appendStaticReadWriteSplittingRule(ruleConfig, result);
        }
    }

    private void appendStaticReadWriteSplittingRule(YamlRuleConfiguration ruleConfig, StringBuilder result) {
        Iterator dataSources = ((YamlReadwriteSplittingRuleConfiguration)ruleConfig).getDataSources().entrySet().iterator();
        Iterator loadBalancers = ((YamlReadwriteSplittingRuleConfiguration)ruleConfig).getLoadBalancers().entrySet().iterator();
        while (dataSources.hasNext()) {
            Map.Entry entryDataSources = dataSources.next();
            Map.Entry<String, YamlAlgorithmConfiguration> entryLoadBalances = loadBalancers.next();
            YamlStaticReadwriteSplittingStrategyConfiguration staticStrategy = ((YamlReadwriteSplittingDataSourceRuleConfiguration)entryDataSources.getValue()).getStaticStrategy();
            String dataSourceName = (String)entryDataSources.getKey();
            String writeDataSourceName = staticStrategy.getWriteDataSourceName();
            String readDataSourceNames = this.appendReadDataSourceNames(staticStrategy.getReadDataSourceNames());
            String loadBalancerType = this.appendLoadBalancer(((YamlReadwriteSplittingDataSourceRuleConfiguration)entryDataSources.getValue()).getLoadBalancerName(), entryLoadBalances);
            result.append(String.format(DistSQLScriptConstants.READWRITE_SPLITTING, dataSourceName, writeDataSourceName, readDataSourceNames, loadBalancerType));
            if (!dataSources.hasNext()) continue;
            result.append(",");
        }
        result.append(";").append(System.lineSeparator());
    }

    private String appendReadDataSourceNames(Collection<String> readDataSourceNames) {
        StringBuilder result = new StringBuilder();
        Iterator<String> iterator = readDataSourceNames.iterator();
        while (iterator.hasNext()) {
            String readDataSourceName = iterator.next();
            result.append(String.format("%s", readDataSourceName));
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    private String appendLoadBalancer(String loadBalancerName, Map.Entry<String, YamlAlgorithmConfiguration> loadBalancers) {
        StringBuilder result = new StringBuilder();
        String loadBalancerProperties = "";
        if (loadBalancers.getValue().getProps().isEmpty()) {
            result.append(String.format("TYPE(NAME=\"%s\")", loadBalancers.getValue().getType()));
        } else {
            for (Map.Entry<Object, Object> entry : loadBalancers.getValue().getProps().entrySet()) {
                if (loadBalancerName != entry.getKey()) continue;
                loadBalancerProperties = this.appendLoadBalancerProperties(loadBalancers.getValue().getProps());
            }
            result.append(String.format("TYPE(NAME=\"%s\", PROPERTIES(%s))", loadBalancers.getValue().getType(), loadBalancerProperties));
        }
        return result.toString();
    }

    private String appendLoadBalancerProperties(Properties loadBalancerProperties) {
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<Object, Object>> iterator = loadBalancerProperties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            result.append(String.format("\"%s\"=\"%s\"", entry.getKey(), entry.getValue()));
            while (iterator.hasNext()) {
                result.append(",");
            }
        }
        return result.toString();
    }

    private void appendDatabaseDiscoveryRules(Collection<YamlRuleConfiguration> ruleConfigs, StringBuilder result) {
        if (ruleConfigs.isEmpty()) {
            return;
        }
        result.append("CREATE DB_DISCOVERY RULE");
        for (YamlRuleConfiguration ruleConfig : ruleConfigs) {
            Iterator dataSourcesIterator = ((YamlDatabaseDiscoveryRuleConfiguration)ruleConfig).getDataSources().entrySet().iterator();
            while (dataSourcesIterator.hasNext()) {
                Map.Entry entry = dataSourcesIterator.next();
                String databaseDiscoveryName = (String)entry.getKey();
                String databaseSourceNames = this.getDatabaseDiscoveryResources(((YamlDatabaseDiscoveryDataSourceRuleConfiguration)entry.getValue()).getDataSourceNames());
                String databaseType = this.getDatabaseDiscoveryType(((YamlDatabaseDiscoveryDataSourceRuleConfiguration)entry.getValue()).getDiscoveryTypeName(), ruleConfig);
                String databaseHeartbeatProperty = this.getDatabaseDiscoveryHeartbeat(((YamlDatabaseDiscoveryDataSourceRuleConfiguration)entry.getValue()).getDiscoveryHeartbeatName(), ruleConfig);
                result.append(String.format(DistSQLScriptConstants.DB_DISCOVERY, databaseDiscoveryName, databaseSourceNames, databaseType, databaseHeartbeatProperty));
                if (!dataSourcesIterator.hasNext()) continue;
                result.append(",");
            }
            result.append(";").append(System.lineSeparator());
        }
    }

    private String getDatabaseDiscoveryResources(Collection<String> databaseDiscoveryNames) {
        StringBuilder result = new StringBuilder();
        Iterator<String> iterator = databaseDiscoveryNames.iterator();
        while (iterator.hasNext()) {
            String databaseDiscoveryName = iterator.next();
            result.append(databaseDiscoveryName);
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    private String getDatabaseDiscoveryHeartbeat(String discoveryHeartbeatName, YamlRuleConfiguration ruleConfig) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry entry : ((YamlDatabaseDiscoveryRuleConfiguration)ruleConfig).getDiscoveryHeartbeats().entrySet()) {
            if (!((String)entry.getKey()).equals(discoveryHeartbeatName)) continue;
            this.getDatabaseDiscoveryProperties(((YamlDatabaseDiscoveryHeartBeatConfiguration)entry.getValue()).getProps(), result);
        }
        return result.toString();
    }

    private String getDatabaseDiscoveryType(String discoveryTypeName, YamlRuleConfiguration ruleConfig) {
        StringBuilder result = new StringBuilder();
        StringBuilder properties = new StringBuilder();
        for (Map.Entry entry : ((YamlDatabaseDiscoveryRuleConfiguration)ruleConfig).getDiscoveryTypes().entrySet()) {
            if (!((String)entry.getKey()).equals(discoveryTypeName)) continue;
            this.getDatabaseDiscoveryProperties(((YamlAlgorithmConfiguration)entry.getValue()).getProps(), properties);
            String typeName = ((YamlAlgorithmConfiguration)entry.getValue()).getType();
            String typePros = properties.toString();
            result.append(String.format("TYPE(NAME='%s', PROPERTIES(%s))", typeName, typePros));
        }
        return result.toString();
    }

    private void getDatabaseDiscoveryProperties(Properties heartbeatProperties, StringBuilder result) {
        for (Map.Entry<Object, Object> entry : heartbeatProperties.entrySet()) {
            result.append(String.format("\"%s\"=\"%s\"", entry.getKey(), entry.getValue()));
        }
    }

    private void appendEncryptRules(Collection<YamlRuleConfiguration> ruleConfigs, StringBuilder result) {
        if (ruleConfigs.isEmpty()) {
            return;
        }
        result.append("CREATE ENCRYPT RULE");
        for (YamlRuleConfiguration ruleConfig : ruleConfigs) {
            Iterator encryptTables = ((YamlEncryptRuleConfiguration)ruleConfig).getTables().entrySet().iterator();
            while (encryptTables.hasNext()) {
                Map.Entry entry = encryptTables.next();
                String tableName = (String)entry.getKey();
                String columns = this.getEncryptColumns(((YamlEncryptTableRuleConfiguration)entry.getValue()).getColumns(), ruleConfig);
                String queryWithCipher = this.getQueryWithCipher(((YamlEncryptTableRuleConfiguration)entry.getValue()).getQueryWithCipherColumn(), ruleConfig);
                result.append(String.format(DistSQLScriptConstants.ENCRYPT, tableName, columns, queryWithCipher));
                if (!encryptTables.hasNext()) continue;
                result.append(",").append(System.lineSeparator());
            }
            result.append(";").append(System.lineSeparator());
        }
    }

    private String getEncryptColumns(Map<String, YamlEncryptColumnRuleConfiguration> columns, YamlRuleConfiguration ruleConfig) {
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<String, YamlEncryptColumnRuleConfiguration>> columnsIter = columns.entrySet().iterator();
        while (columnsIter.hasNext()) {
            Map.Entry<String, YamlEncryptColumnRuleConfiguration> entry = columnsIter.next();
            String columnName = entry.getKey();
            String columnPlainAndCipher = this.getColumnPlainAndCipher(entry.getValue());
            String columnType = this.getColumnType(entry.getValue().getEncryptorName(), ruleConfig);
            result.append(String.format("(NAME=%s,%s,%s)", columnName, columnPlainAndCipher, columnType));
            if (!columnsIter.hasNext()) continue;
            result.append(",").append(System.lineSeparator());
        }
        return result.toString();
    }

    private String getColumnPlainAndCipher(YamlEncryptColumnRuleConfiguration encryptColumnRuleConfiguration) {
        StringBuilder result = new StringBuilder();
        String plainColumnName = encryptColumnRuleConfiguration.getPlainColumn();
        String cipherColumnName = encryptColumnRuleConfiguration.getCipherColumn();
        if (null != plainColumnName) {
            result.append(String.format("PLAIN=%s", plainColumnName));
        }
        if (null != cipherColumnName) {
            if (null != plainColumnName) {
                result.append(",");
            }
            result.append(String.format("CIPHER=%s", cipherColumnName));
        }
        return result.toString();
    }

    private String getColumnType(String encryptorName, YamlRuleConfiguration ruleConfig) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry entry : ((YamlEncryptRuleConfiguration)ruleConfig).getEncryptors().entrySet()) {
            if (!((String)entry.getKey()).equals(encryptorName)) continue;
            String typeName = ((YamlAlgorithmConfiguration)entry.getValue()).getType();
            if (((YamlAlgorithmConfiguration)entry.getValue()).getProps().isEmpty()) {
                result.append(String.format("TYPE(NAME='%s')", typeName));
                continue;
            }
            String properties = this.getColumnTypeProperties(((YamlAlgorithmConfiguration)entry.getValue()).getProps());
            result.append(String.format("TYPE(NAME='%s', PROPERTIES(%s))", typeName, properties));
        }
        return result.toString();
    }

    private String getColumnTypeProperties(Properties properties) {
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<Object, Object>> props = properties.entrySet().iterator();
        while (props.hasNext()) {
            Map.Entry<Object, Object> entry = props.next();
            result.append(String.format("\"%s\"=\"%s\"", entry.getKey(), entry.getValue()));
            if (!props.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    private String getQueryWithCipher(Boolean queryWithCipherColumn, YamlRuleConfiguration ruleConfig) {
        return String.valueOf(null == queryWithCipherColumn ? Boolean.valueOf(((YamlEncryptRuleConfiguration)ruleConfig).isQueryWithCipherColumn()) : queryWithCipherColumn.toString().toLowerCase());
    }

    private void appendShadowRules(Collection<YamlRuleConfiguration> ruleConfigs, StringBuilder result) {
        if (ruleConfigs.isEmpty()) {
            return;
        }
        result.append("CREATE SHADOW RULE");
        for (YamlRuleConfiguration ruleConfig : ruleConfigs) {
            Iterator shadowDataSourcesIter = ((YamlShadowRuleConfiguration)ruleConfig).getDataSources().entrySet().iterator();
            while (shadowDataSourcesIter.hasNext()) {
                Map.Entry entry = shadowDataSourcesIter.next();
                String shadowRuleName = (String)entry.getKey();
                String source = ((YamlShadowDataSourceConfiguration)entry.getValue()).getProductionDataSourceName();
                String shadow = ((YamlShadowDataSourceConfiguration)entry.getValue()).getShadowDataSourceName();
                String shadowTables = this.getShadowTables((String)entry.getKey(), ruleConfig);
                result.append(String.format(DistSQLScriptConstants.SHADOW, shadowRuleName, source, shadow, shadowTables));
                if (!shadowDataSourcesIter.hasNext()) continue;
                result.append(",");
            }
            result.append(";").append(System.lineSeparator());
        }
    }

    private String getShadowTables(String shadowName, YamlRuleConfiguration ruleConfig) {
        StringBuilder result = new StringBuilder();
        Iterator shadowTablesIter = ((YamlShadowRuleConfiguration)ruleConfig).getTables().entrySet().iterator();
        while (shadowTablesIter.hasNext()) {
            Map.Entry entry = shadowTablesIter.next();
            if (this.isBelongToShadowRule(shadowName, ((YamlShadowTableConfiguration)entry.getValue()).getDataSourceNames()).booleanValue()) {
                String tableName = (String)entry.getKey();
                String tableTypes = this.getShadowTableTypes(((YamlShadowTableConfiguration)entry.getValue()).getShadowAlgorithmNames(), ruleConfig);
                result.append(String.format("%s(%s)", tableName, tableTypes));
            }
            if (!shadowTablesIter.hasNext()) continue;
            result.append(",").append(System.lineSeparator());
        }
        return result.toString();
    }

    private Boolean isBelongToShadowRule(String shadowName, Collection<String> dataSourceNames) {
        for (String dataSourceName : dataSourceNames) {
            if (!dataSourceName.equals(shadowName)) continue;
            return true;
        }
        return false;
    }

    private String getShadowTableTypes(Collection<String> shadowAlgorithmNames, YamlRuleConfiguration ruleConfig) {
        StringBuilder result = new StringBuilder();
        Iterator<String> shadowAlgorithmNamesIter = shadowAlgorithmNames.iterator();
        while (shadowAlgorithmNamesIter.hasNext()) {
            String shadowAlgorithmName = shadowAlgorithmNamesIter.next();
            for (Map.Entry entry : ((YamlShadowRuleConfiguration)ruleConfig).getShadowAlgorithms().entrySet()) {
                if (!((String)entry.getKey()).equals(shadowAlgorithmName)) continue;
                String typeName = ((YamlAlgorithmConfiguration)entry.getValue()).getType();
                String typeProperties = this.getAlgorithmProperties(((YamlAlgorithmConfiguration)entry.getValue()).getProps());
                result.append(String.format("(TYPE(NAME=\"%s\", PROPERTIES(%s)))", typeName, typeProperties));
            }
            if (!shadowAlgorithmNamesIter.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    private String getAlgorithmProperties(Properties algorithmProperties) {
        StringBuilder result = new StringBuilder();
        TreeMap<Object, Object> sortedMap = new TreeMap<Object, Object>(algorithmProperties);
        Set set = sortedMap.keySet();
        Iterator prosIter = set.iterator();
        while (prosIter.hasNext()) {
            String prosKey = (String)prosIter.next();
            String prosValue = algorithmProperties.getProperty(prosKey);
            result.append(String.format("\"%s\"=\"%s\"", prosKey, prosValue));
            if (!prosIter.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }
}

