/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.hint.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.hint.HintManager;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataMergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.RuleNotExistedException;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.hint.enums.HintShardingType;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.hint.executor.AbstractHintQueryExecutor;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.hint.result.ShowShardingHintStatusResult;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sharding.distsql.parser.statement.hint.ShowShardingHintStatusStatement;

public final class ShowShardingHintStatusExecutor
extends AbstractHintQueryExecutor<ShowShardingHintStatusStatement> {
    private final ConnectionSession connectionSession;

    @Override
    protected List<QueryHeader> createQueryHeaders() {
        ArrayList<QueryHeader> result = new ArrayList<QueryHeader>(4);
        result.add(new QueryHeader("", "", "table_name", "", 1, "CHAR", 255, 0, false, false, false, false));
        result.add(new QueryHeader("", "", "database_sharding_values", "", 1, "CHAR", 255, 0, false, false, false, false));
        result.add(new QueryHeader("", "", "table_sharding_values", "", 1, "CHAR", 255, 0, false, false, false, false));
        result.add(new QueryHeader("", "", "sharding_type", "", 1, "CHAR", 255, 0, false, false, false, false));
        return result;
    }

    @Override
    protected MergedResult createMergedResult() {
        HashMap<String, ShowShardingHintStatusResult> results = new HashMap<String, ShowShardingHintStatusResult>();
        ShardingSphereDatabase database = ProxyContext.getInstance().getDatabase(this.connectionSession.getDatabaseName());
        if (!database.isComplete()) {
            throw new RuleNotExistedException();
        }
        String schemaName = DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)this.connectionSession.getDatabaseType(), (String)this.connectionSession.getDatabaseName());
        Collection tableNames = database.getSchema(schemaName).getAllTableNames();
        for (String each : tableNames) {
            if (HintManager.isDatabaseShardingOnly()) {
                this.fillShardingValues(results, each, HintManager.getDatabaseShardingValues(), Collections.emptyList());
                continue;
            }
            this.fillShardingValues(results, each, HintManager.getDatabaseShardingValues((String)each), HintManager.getTableShardingValues((String)each));
        }
        return this.convertToMergedResult(results.values());
    }

    private void fillShardingValues(Map<String, ShowShardingHintStatusResult> results, String logicTable, Collection<Comparable<?>> databaseShardingValues, Collection<Comparable<?>> tableShardingValues) {
        if (!results.containsKey(logicTable)) {
            results.put(logicTable, new ShowShardingHintStatusResult(logicTable));
        }
        for (Comparable<?> each : databaseShardingValues) {
            results.get(logicTable).getDatabaseShardingValues().add(each.toString());
        }
        for (Comparable<?> each : tableShardingValues) {
            results.get(logicTable).getTableShardingValues().add(each.toString());
        }
    }

    private MergedResult convertToMergedResult(Collection<ShowShardingHintStatusResult> showShardingHintStatusResults) {
        return new LocalDataMergedResult((Collection)showShardingHintStatusResults.stream().map(this::createRow).collect(Collectors.toList()));
    }

    private LocalDataQueryResultRow createRow(ShowShardingHintStatusResult showShardingHintStatusResult) {
        return new LocalDataQueryResultRow(new Object[]{showShardingHintStatusResult.getLogicTable(), String.join((CharSequence)",", showShardingHintStatusResult.getDatabaseShardingValues()), String.join((CharSequence)",", showShardingHintStatusResult.getTableShardingValues()), String.valueOf((Object)(HintManager.isDatabaseShardingOnly() ? HintShardingType.DATABASES_ONLY : HintShardingType.DATABASES_TABLES)).toLowerCase()});
    }

    @Generated
    public ShowShardingHintStatusExecutor(ConnectionSession connectionSession) {
        this.connectionSession = connectionSession;
    }
}

