/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.hint.executor;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.shardingsphere.distsql.parser.statement.ral.HintRALStatement;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.hint.HintRALStatementExecutor;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;

public abstract class AbstractHintQueryExecutor<T extends HintRALStatement>
implements HintRALStatementExecutor<T> {
    private List<QueryHeader> queryHeaders;
    private MergedResult mergedResult;

    @Override
    public final ResponseHeader execute() {
        this.queryHeaders = this.createQueryHeaders();
        this.mergedResult = this.createMergedResult();
        return new QueryResponseHeader(this.queryHeaders);
    }

    protected abstract List<QueryHeader> createQueryHeaders();

    protected abstract MergedResult createMergedResult();

    @Override
    public final boolean next() throws SQLException {
        return null != this.mergedResult && this.mergedResult.next();
    }

    @Override
    public final QueryResponseRow getQueryResponseRow() throws SQLException {
        ArrayList<QueryResponseCell> cells = new ArrayList<QueryResponseCell>(this.queryHeaders.size());
        for (int i = 0; i < this.queryHeaders.size(); ++i) {
            cells.add(new QueryResponseCell(this.queryHeaders.get(i).getColumnType(), this.mergedResult.getValue(i + 1, Object.class)));
        }
        return new QueryResponseRow(cells);
    }
}

