/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.hint;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.statement.ral.HintRALStatement;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.RALBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.hint.HintRALStatementExecutor;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.hint.HintRALStatementExecutorFactory;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;

public final class HintRALBackendHandler
extends RALBackendHandler {
    private final HintRALStatement sqlStatement;
    private final ConnectionSession connectionSession;
    private HintRALStatementExecutor<? extends HintRALStatement> hintRALStatementExecutor;

    @Override
    public ResponseHeader execute() {
        ShardingSpherePreconditions.checkState((boolean)((Boolean)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_HINT_ENABLED)), () -> new UnsupportedSQLOperationException(String.format("%s should be true, please check your config", ConfigurationPropertyKey.PROXY_HINT_ENABLED.getKey())));
        this.hintRALStatementExecutor = HintRALStatementExecutorFactory.newInstance(this.sqlStatement, this.connectionSession);
        return this.hintRALStatementExecutor.execute();
    }

    @Override
    public boolean next() throws SQLException {
        return this.hintRALStatementExecutor.next();
    }

    @Override
    public QueryResponseRow getRowData() throws SQLException {
        return this.hintRALStatementExecutor.getQueryResponseRow();
    }

    @Generated
    public HintRALBackendHandler(HintRALStatement sqlStatement, ConnectionSession connectionSession) {
        this.sqlStatement = sqlStatement;
        this.connectionSession = connectionSession;
    }

    @Generated
    public HintRALStatement getSqlStatement() {
        return this.sqlStatement;
    }

    @Override
    @Generated
    public ConnectionSession getConnectionSession() {
        return this.connectionSession;
    }

    @Generated
    public HintRALStatementExecutor<? extends HintRALStatement> getHintRALStatementExecutor() {
        return this.hintRALStatementExecutor;
    }
}

