/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.common.checker;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.resource.MissingRequiredResourcesException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.factory.ReadQueryLoadBalanceAlgorithmFactory;

public final class ReadwriteSplittingRuleConfigurationImportChecker {
    public void check(ShardingSphereDatabase database, ReadwriteSplittingRuleConfiguration currentRuleConfig) {
        if (null == database || null == currentRuleConfig) {
            return;
        }
        String databaseName = database.getName();
        this.checkResources(databaseName, database, currentRuleConfig);
        this.checkLoadBalancers(currentRuleConfig);
    }

    private void checkResources(String databaseName, ShardingSphereDatabase database, ReadwriteSplittingRuleConfiguration currentRuleConfig) {
        LinkedHashSet requireResources = new LinkedHashSet();
        LinkedHashSet requireDiscoverableResources = new LinkedHashSet();
        currentRuleConfig.getDataSources().forEach(each -> {
            if (null != each.getDynamicStrategy()) {
                requireDiscoverableResources.add(each.getDynamicStrategy().getAutoAwareDataSourceName());
            }
            if (null != each.getStaticStrategy()) {
                if (null != each.getStaticStrategy().getWriteDataSourceName()) {
                    requireResources.add(each.getStaticStrategy().getWriteDataSourceName());
                }
                if (!each.getStaticStrategy().getReadDataSourceNames().isEmpty()) {
                    requireResources.addAll(each.getStaticStrategy().getReadDataSourceNames());
                }
            }
        });
        Collection notExistResources = database.getResourceMetaData().getNotExistedResources(requireResources);
        ShardingSpherePreconditions.checkState((boolean)notExistResources.isEmpty(), () -> new MissingRequiredResourcesException(databaseName, notExistResources));
        Collection<String> logicResources = this.getLogicResources(database);
        Collection notExistLogicResources = requireDiscoverableResources.stream().filter(each -> !logicResources.contains(each)).collect(Collectors.toSet());
        ShardingSpherePreconditions.checkState((boolean)notExistLogicResources.isEmpty(), () -> new MissingRequiredResourcesException(databaseName, notExistLogicResources));
    }

    private Collection<String> getLogicResources(ShardingSphereDatabase database) {
        return database.getRuleMetaData().getRules().stream().filter(each -> each instanceof DataSourceContainedRule).map(each -> ((DataSourceContainedRule)each).getDataSourceMapper().keySet()).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private void checkLoadBalancers(ReadwriteSplittingRuleConfiguration currentRuleConfig) {
        Collection notExistedLoadBalancers = currentRuleConfig.getLoadBalancers().values().stream().map(AlgorithmConfiguration::getType).filter(each -> !ReadQueryLoadBalanceAlgorithmFactory.contains((String)each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)notExistedLoadBalancers.isEmpty(), () -> new InvalidAlgorithmConfigurationException("Load balancers", notExistedLoadBalancers));
    }
}

