/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.common.checker;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.factory.DatabaseDiscoveryProviderAlgorithmFactory;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.resource.MissingRequiredResourcesException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.distsql.exception.rule.MissingRequiredAlgorithmException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;

public final class DatabaseDiscoveryRuleConfigurationImportChecker {
    private static final String DB_DISCOVERY = "Database discovery";

    public void check(ShardingSphereDatabase database, DatabaseDiscoveryRuleConfiguration currentRuleConfig) {
        if (null == database || null == currentRuleConfig) {
            return;
        }
        String databaseName = database.getName();
        this.checkResources(databaseName, database, currentRuleConfig);
        this.checkDiscoverTypeAndHeartbeat(databaseName, currentRuleConfig);
    }

    private void checkResources(String databaseName, ShardingSphereDatabase database, DatabaseDiscoveryRuleConfiguration currentRuleConfig) {
        LinkedHashSet requireResources = new LinkedHashSet();
        currentRuleConfig.getDataSources().forEach(each -> requireResources.addAll(each.getDataSourceNames()));
        Collection notExistResources = database.getResourceMetaData().getNotExistedResources(requireResources);
        ShardingSpherePreconditions.checkState((boolean)notExistResources.isEmpty(), () -> new MissingRequiredResourcesException(databaseName, notExistResources));
    }

    private void checkDiscoverTypeAndHeartbeat(String databaseName, DatabaseDiscoveryRuleConfiguration currentRuleConfig) {
        Collection invalidInput = currentRuleConfig.getDiscoveryTypes().values().stream().map(AlgorithmConfiguration::getType).filter(each -> !DatabaseDiscoveryProviderAlgorithmFactory.contains((String)each)).collect(Collectors.toList());
        ShardingSpherePreconditions.checkState((boolean)invalidInput.isEmpty(), () -> new InvalidAlgorithmConfigurationException(DB_DISCOVERY.toLowerCase(), invalidInput));
        currentRuleConfig.getDataSources().forEach(each -> {
            if (!currentRuleConfig.getDiscoveryTypes().containsKey(each.getDiscoveryTypeName())) {
                invalidInput.add(each.getDiscoveryTypeName());
            }
            if (!currentRuleConfig.getDiscoveryHeartbeats().containsKey(each.getDiscoveryHeartbeatName())) {
                invalidInput.add(each.getDiscoveryHeartbeatName());
            }
        });
        ShardingSpherePreconditions.checkState((boolean)invalidInput.isEmpty(), () -> new MissingRequiredAlgorithmException(DB_DISCOVERY, databaseName, invalidInput));
    }
}

