/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral;

import org.apache.shardingsphere.distsql.parser.statement.ral.RALStatement;
import org.apache.shardingsphere.infra.distsql.update.GlobalRuleRALUpdater;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class UpdatableGlobalRuleRALBackendHandler
implements ProxyBackendHandler {
    private final RALStatement sqlStatement;
    private final GlobalRuleRALUpdater updater;

    public UpdatableGlobalRuleRALBackendHandler(RALStatement sqlStatement, GlobalRuleRALUpdater updater) {
        this.sqlStatement = sqlStatement;
        this.updater = updater;
    }

    @Override
    public ResponseHeader execute() {
        this.updater.executeUpdate(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData(), (SQLStatement)this.sqlStatement);
        this.persistNewRuleConfigurations();
        return new UpdateResponseHeader((SQLStatement)this.sqlStatement);
    }

    private void persistNewRuleConfigurations() {
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        metaDataContexts.getPersistService().getGlobalRuleService().persist(metaDataContexts.getMetaData().getGlobalRuleMetaData().getConfigurations());
    }
}

