/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.parser.statement.ral.RALStatement;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataMergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.RALBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;

public abstract class QueryableRALBackendHandler<E extends RALStatement>
extends RALBackendHandler<E> {
    private List<QueryHeader> queryHeaders;
    private MergedResult mergedResult;

    @Override
    public final ResponseHeader execute() {
        this.queryHeaders = this.createQueryHeader();
        this.mergedResult = this.createMergedResult();
        return new QueryResponseHeader(this.queryHeaders);
    }

    private List<QueryHeader> createQueryHeader() {
        return this.getColumnNames().stream().map(each -> new QueryHeader("", "", (String)each, (String)each, 1, "CHAR", 255, 0, false, false, false, false)).collect(Collectors.toList());
    }

    private MergedResult createMergedResult() {
        return new LocalDataMergedResult(this.getRows(ProxyContext.getInstance().getContextManager()));
    }

    @Override
    public final boolean next() throws SQLException {
        return null != this.mergedResult && this.mergedResult.next();
    }

    @Override
    public final QueryResponseRow getRowData() throws SQLException {
        ArrayList<QueryResponseCell> cells = new ArrayList<QueryResponseCell>(this.queryHeaders.size());
        for (int i = 0; i < this.queryHeaders.size(); ++i) {
            cells.add(new QueryResponseCell(this.queryHeaders.get(i).getColumnType(), this.mergedResult.getValue(i + 1, Object.class)));
        }
        return new QueryResponseRow(cells);
    }

    protected abstract Collection<String> getColumnNames();

    protected abstract Collection<LocalDataQueryResultRow> getRows(ContextManager var1);
}

