/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.shardingsphere.distsql.parser.statement.ral.RALStatement;
import org.apache.shardingsphere.infra.distsql.query.GlobalRuleDistSQLResultSet;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class QueryableGlobalRuleRALBackendHandler
implements ProxyBackendHandler {
    private final RALStatement sqlStatement;
    private final GlobalRuleDistSQLResultSet resultSet;

    public QueryableGlobalRuleRALBackendHandler(RALStatement sqlStatement, GlobalRuleDistSQLResultSet resultSet) {
        this.sqlStatement = sqlStatement;
        this.resultSet = resultSet;
    }

    @Override
    public ResponseHeader execute() {
        this.resultSet.init(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData(), (SQLStatement)this.sqlStatement);
        ArrayList<QueryHeader> queryHeaders = new ArrayList<QueryHeader>();
        for (String each : this.resultSet.getColumnNames()) {
            queryHeaders.add(new QueryHeader("", "", each, each, 1, "CHAR", 255, 0, false, false, false, false));
        }
        return new QueryResponseHeader(queryHeaders);
    }

    @Override
    public boolean next() {
        return this.resultSet.next();
    }

    @Override
    public QueryResponseRow getRowData() {
        Collection rowData = this.resultSet.getRowData();
        ArrayList<QueryResponseCell> result = new ArrayList<QueryResponseCell>(rowData.size());
        for (Object each : rowData) {
            result.add(new QueryResponseCell(1, each));
        }
        return new QueryResponseRow(result);
    }
}

