/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql;

import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.statement.DistSQLStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.RALStatement;
import org.apache.shardingsphere.distsql.parser.statement.rdl.RDLStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.RQLStatement;
import org.apache.shardingsphere.distsql.parser.statement.rul.RULStatement;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.RALBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.handler.distsql.rdl.RDLBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.handler.distsql.rql.RQLBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.handler.distsql.rul.RULBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;

public final class DistSQLBackendHandlerFactory {
    public static ProxyBackendHandler newInstance(DistSQLStatement sqlStatement, ConnectionSession connectionSession) {
        if (sqlStatement instanceof RQLStatement) {
            return RQLBackendHandlerFactory.newInstance((RQLStatement)sqlStatement, connectionSession);
        }
        if (sqlStatement instanceof RDLStatement) {
            return RDLBackendHandlerFactory.newInstance((RDLStatement)sqlStatement, connectionSession);
        }
        if (sqlStatement instanceof RALStatement) {
            return RALBackendHandlerFactory.newInstance((RALStatement)sqlStatement, connectionSession);
        }
        if (sqlStatement instanceof RULStatement) {
            return RULBackendHandlerFactory.newInstance((RULStatement)sqlStatement, connectionSession);
        }
        throw new UnsupportedSQLOperationException(sqlStatement.getClass().getCanonicalName());
    }

    @Generated
    private DistSQLBackendHandlerFactory() {
    }
}

