/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.database;

import lombok.Generated;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.database.CreateDatabaseBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.database.DropDatabaseBackendHandler;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropDatabaseStatement;

public final class DatabaseOperateBackendHandlerFactory {
    public static ProxyBackendHandler newInstance(SQLStatement sqlStatement, ConnectionSession connectionSession) {
        return DatabaseOperateBackendHandlerFactory.createBackendHandler(sqlStatement, connectionSession);
    }

    private static ProxyBackendHandler createBackendHandler(SQLStatement sqlStatement, ConnectionSession connectionSession) {
        if (sqlStatement instanceof CreateDatabaseStatement) {
            return new CreateDatabaseBackendHandler((CreateDatabaseStatement)sqlStatement);
        }
        if (sqlStatement instanceof DropDatabaseStatement) {
            return new DropDatabaseBackendHandler((DropDatabaseStatement)sqlStatement, connectionSession);
        }
        throw new UnsupportedSQLOperationException(sqlStatement.getClass().getCanonicalName());
    }

    @Generated
    private DatabaseOperateBackendHandlerFactory() {
    }
}

