/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.data.impl;

import io.vertx.core.Future;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.dialect.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngineFactory;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.RuleNotExistedException;
import org.apache.shardingsphere.proxy.backend.handler.data.DatabaseBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;

public final class UnicastDatabaseBackendHandler
implements DatabaseBackendHandler {
    private final DatabaseCommunicationEngineFactory databaseCommunicationEngineFactory = DatabaseCommunicationEngineFactory.getInstance();
    private final QueryContext queryContext;
    private final ConnectionSession connectionSession;
    private DatabaseCommunicationEngine databaseCommunicationEngine;

    @Override
    public Future<ResponseHeader> executeFuture() {
        String databaseName;
        String originDatabase = this.connectionSession.getDatabaseName();
        String string = databaseName = null == originDatabase ? this.getFirstDatabaseName() : originDatabase;
        if (!ProxyContext.getInstance().getDatabase(databaseName).containsDataSource()) {
            throw new RuleNotExistedException();
        }
        this.connectionSession.setCurrentDatabase(databaseName);
        this.databaseCommunicationEngine = this.databaseCommunicationEngineFactory.newDatabaseCommunicationEngine(this.queryContext, this.connectionSession.getBackendConnection(), false);
        return this.databaseCommunicationEngine.executeFuture().eventually(unused -> {
            this.connectionSession.setCurrentDatabase(databaseName);
            return Future.succeededFuture();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseHeader execute() throws SQLException {
        String databaseName;
        String originDatabase = this.connectionSession.getDefaultDatabaseName();
        String string = databaseName = null == originDatabase ? this.getFirstDatabaseName() : originDatabase;
        if (!ProxyContext.getInstance().getDatabase(databaseName).containsDataSource()) {
            throw new RuleNotExistedException();
        }
        try {
            this.connectionSession.setCurrentDatabase(databaseName);
            this.databaseCommunicationEngine = this.databaseCommunicationEngineFactory.newDatabaseCommunicationEngine(this.queryContext, this.connectionSession.getBackendConnection(), false);
            ResponseHeader responseHeader = this.databaseCommunicationEngine.execute();
            return responseHeader;
        }
        finally {
            this.connectionSession.setCurrentDatabase(databaseName);
        }
    }

    private String getFirstDatabaseName() {
        Collection<String> databaseNames = ProxyContext.getInstance().getAllDatabaseNames();
        if (databaseNames.isEmpty()) {
            throw new NoDatabaseSelectedException();
        }
        Optional<String> result = databaseNames.stream().filter(each -> ProxyContext.getInstance().getDatabase((String)each).containsDataSource()).findFirst();
        if (!result.isPresent()) {
            throw new RuleNotExistedException();
        }
        return result.get();
    }

    @Override
    public boolean next() throws SQLException {
        return this.databaseCommunicationEngine.next();
    }

    @Override
    public QueryResponseRow getRowData() throws SQLException {
        return this.databaseCommunicationEngine.getRowData();
    }

    @Override
    public void close() throws SQLException {
        if (null != this.databaseCommunicationEngine) {
            this.databaseCommunicationEngine.close();
        }
    }

    @Generated
    public UnicastDatabaseBackendHandler(QueryContext queryContext, ConnectionSession connectionSession) {
        this.queryContext = queryContext;
        this.connectionSession = connectionSession;
    }
}

