/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.data;

import io.vertx.core.Future;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngineFactory;
import org.apache.shardingsphere.proxy.backend.handler.data.DatabaseBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.data.impl.UnicastDatabaseBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.DALStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.SetStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DoStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class DatabaseBackendHandlerFactory {
    public static DatabaseBackendHandler newInstance(QueryContext queryContext, ConnectionSession connectionSession, boolean preferPreparedStatement) {
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        final SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof DoStatement) {
            return new UnicastDatabaseBackendHandler(queryContext, connectionSession);
        }
        if (sqlStatement instanceof SetStatement && null == connectionSession.getDatabaseName()) {
            return new DatabaseBackendHandler(){

                @Override
                public Future<ResponseHeader> executeFuture() {
                    return Future.succeededFuture((Object)new UpdateResponseHeader(sqlStatement));
                }

                @Override
                public ResponseHeader execute() {
                    return new UpdateResponseHeader(sqlStatement);
                }
            };
        }
        if (sqlStatement instanceof DALStatement || sqlStatement instanceof SelectStatement && null == ((SelectStatement)sqlStatement).getFrom()) {
            return new UnicastDatabaseBackendHandler(queryContext, connectionSession);
        }
        return DatabaseCommunicationEngineFactory.getInstance().newDatabaseCommunicationEngine(queryContext, connectionSession.getBackendConnection(), preferPreparedStatement);
    }

    @Generated
    private DatabaseBackendHandlerFactory() {
    }
}

