/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.admin.postgresql.executor;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.metadata.database.resource.ShardingSphereResourceMetaData;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.AbstractDatabaseMetadataExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class SelectDatabaseExecutor
extends AbstractDatabaseMetadataExecutor.DefaultDatabaseMetadataExecutor {
    private static final String DATABASE_NAME = "databasename";
    private static final String DATNAME = "datname";
    private static final String NAME = "name";
    private final Set<String> columnNames = new LinkedHashSet<String>();
    private final SelectStatement sqlStatement;
    private String databaseNameAlias = "databasename";
    private boolean isQueryDatabase;

    public SelectDatabaseExecutor(SelectStatement sqlStatement, String sql) {
        super(sql);
        this.sqlStatement = sqlStatement;
    }

    @Override
    protected void createPreProcessing() {
        this.removeDuplicatedRow();
        this.addDefaultRow();
    }

    private void addDefaultRow() {
        Collection schemaWithoutDataSource = ProxyContext.getInstance().getAllDatabaseNames().stream().filter(each -> SelectDatabaseExecutor.hasDataSource(each) == false).collect(Collectors.toList());
        schemaWithoutDataSource.forEach(each -> this.getRows().addLast(this.getDefaultRowData((String)each)));
    }

    private void removeDuplicatedRow() {
        if (this.isQueryDatabase) {
            List<Map> toBeRemovedRow = this.getRows().stream().collect(Collectors.groupingBy(each -> each.get(this.databaseNameAlias), Collectors.toCollection(LinkedList::new))).values().stream().filter(each -> each.size() > 1).map(LinkedList::getLast).collect(Collectors.toList());
            toBeRemovedRow.forEach(each -> this.getRows().remove(each));
        }
    }

    @Override
    protected List<String> getDatabaseNames(ConnectionSession connectionSession) {
        Collection databaseNames = ProxyContext.getInstance().getAllDatabaseNames().stream().filter(each -> SelectDatabaseExecutor.hasAuthority(each, connectionSession.getGrantee())).collect(Collectors.toList());
        return databaseNames.stream().filter(AbstractDatabaseMetadataExecutor::hasDataSource).collect(Collectors.toList());
    }

    @Override
    protected void rowPostProcessing(String databaseName, Map<String, Object> rowMap, Map<String, String> aliasMap) {
        this.buildColumnNames(aliasMap);
        ShardingSphereResourceMetaData resourceMetaData = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabase(databaseName).getResourceMetaData();
        Set catalogs = resourceMetaData.getDataSources().keySet().stream().map(each -> resourceMetaData.getDataSourceMetaData(each).getCatalog()).collect(Collectors.toSet());
        this.databaseNameAlias = aliasMap.getOrDefault(DATABASE_NAME, aliasMap.getOrDefault(DATNAME, aliasMap.getOrDefault(NAME, "")));
        String rowValue = rowMap.getOrDefault(this.databaseNameAlias, "").toString();
        boolean bl = this.isQueryDatabase = !rowValue.isEmpty();
        if (catalogs.contains(rowValue)) {
            rowMap.replace(this.databaseNameAlias, databaseName);
        } else {
            rowMap.clear();
        }
    }

    private void buildColumnNames(Map<String, String> aliasMap) {
        aliasMap.forEach((key, value) -> this.columnNames.add(value.isEmpty() ? key : value));
    }

    private Map<String, Object> getDefaultRowData(String schemaName) {
        if (this.columnNames.isEmpty()) {
            this.columnNames.addAll(this.getDefaultColumnNames());
        }
        Map<String, Object> result = this.columnNames.stream().collect(Collectors.toMap(each -> each, each -> ""));
        result.replace(this.databaseNameAlias, schemaName);
        return result;
    }

    private Set<String> getDefaultColumnNames() {
        Collection projections = this.sqlStatement.getProjections().getProjections();
        if (projections.stream().anyMatch(each -> !(each instanceof ColumnProjectionSegment))) {
            return Collections.singleton(this.databaseNameAlias);
        }
        return projections.stream().map(each -> {
            ColumnProjectionSegment segment = (ColumnProjectionSegment)each;
            return segment.getAlias().isPresent() ? (String)segment.getAlias().get() : segment.getColumn().getIdentifier().getValue();
        }).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

