/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.admin.postgresql.executor;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.apache.shardingsphere.db.protocol.CommonConstants;
import org.apache.shardingsphere.dialect.exception.data.InvalidParameterValueException;
import org.apache.shardingsphere.proxy.backend.handler.admin.postgresql.PostgreSQLCharacterSets;
import org.apache.shardingsphere.proxy.backend.handler.admin.postgresql.PostgreSQLSessionVariableHandler;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;

public final class PostgreSQLSetCharsetExecutor
implements PostgreSQLSessionVariableHandler {
    @Override
    public void handle(ConnectionSession connectionSession, String variableName, String assignValue) {
        String value = this.formatValue(assignValue.trim());
        connectionSession.getAttributeMap().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).set((Object)this.parseCharset(value));
    }

    private String formatValue(String value) {
        return value.startsWith("'") && value.endsWith("'") ? value.substring(1, value.length() - 1).trim() : value;
    }

    private Charset parseCharset(String value) {
        try {
            String result = value.toLowerCase(Locale.ROOT);
            return "default".equals(result) ? StandardCharsets.UTF_8 : PostgreSQLCharacterSets.findCharacterSet(result);
        }
        catch (IllegalArgumentException ignored) {
            throw new InvalidParameterValueException("client_encoding", value.toLowerCase(Locale.ROOT));
        }
    }

    public String getType() {
        return "client_encoding";
    }
}

