/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.admin.postgresql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.AbstractDatabaseMetadataExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutorCreator;
import org.apache.shardingsphere.proxy.backend.handler.admin.postgresql.PostgreSQLResetVariableAdminExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.postgresql.PostgreSQLSetVariableAdminExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.postgresql.PostgreSQLShowVariableExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.postgresql.executor.SelectDatabaseExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.postgresql.executor.SelectTableExecutor;
import org.apache.shardingsphere.sql.parser.sql.common.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.ResetParameterStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.SetStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.ShowStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class PostgreSQLAdminExecutorCreator
implements DatabaseAdminExecutorCreator {
    private static final String PG_TABLESPACE = "pg_tablespace";
    private static final String PG_DATABASE = "pg_database";
    private static final String PG_TRIGGER = "pg_trigger";
    private static final String PG_INHERITS = "pg_inherits";
    private static final String PG_CLASS = "pg_class";
    private static final String PG_PREFIX = "pg_";

    @Override
    public Optional<DatabaseAdminExecutor> create(SQLStatementContext<?> sqlStatementContext) {
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof ShowStatement) {
            return Optional.of(new PostgreSQLShowVariableExecutor((ShowStatement)sqlStatement));
        }
        return Optional.empty();
    }

    @Override
    public Optional<DatabaseAdminExecutor> create(SQLStatementContext<?> sqlStatementContext, String sql, String databaseName) {
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof SelectStatement) {
            Collection<String> selectedTableNames = this.getSelectedTableNames((SelectStatement)sqlStatement);
            if (selectedTableNames.contains(PG_DATABASE)) {
                return Optional.of(new SelectDatabaseExecutor((SelectStatement)sqlStatement, sql));
            }
            if (this.isQueryPgTable(selectedTableNames)) {
                return Optional.of(new SelectTableExecutor(sql));
            }
            for (String each : selectedTableNames) {
                if (!each.startsWith(PG_PREFIX)) continue;
                return Optional.of(new AbstractDatabaseMetadataExecutor.DefaultDatabaseMetadataExecutor(sql));
            }
        }
        if (sqlStatement instanceof SetStatement) {
            return Optional.of(new PostgreSQLSetVariableAdminExecutor((SetStatement)sqlStatement));
        }
        if (sqlStatement instanceof ResetParameterStatement) {
            return Optional.of(new PostgreSQLResetVariableAdminExecutor((ResetParameterStatement)sqlStatement));
        }
        return Optional.empty();
    }

    private boolean isQueryPgTable(Collection<String> selectedTableNames) {
        boolean isComplexQueryTable = selectedTableNames.contains(PG_CLASS) && selectedTableNames.contains(PG_TRIGGER) && selectedTableNames.contains(PG_INHERITS);
        return isComplexQueryTable || selectedTableNames.contains(PG_TABLESPACE);
    }

    private Collection<String> getSelectedTableNames(SelectStatement sqlStatement) {
        TableExtractor extractor = new TableExtractor();
        extractor.extractTablesFromSelect(sqlStatement);
        LinkedList extracted = new LinkedList(extractor.getTableContext());
        for (TableSegment each : extractor.getTableContext()) {
            if (!(each instanceof SubqueryTableSegment)) continue;
            TableExtractor subExtractor = new TableExtractor();
            subExtractor.extractTablesFromSelect(((SubqueryTableSegment)each).getSubquery().getSelect());
            extracted.addAll(subExtractor.getTableContext());
        }
        ArrayList<String> result = new ArrayList<String>(extracted.size());
        for (TableSegment each : extracted) {
            if (!(each instanceof SimpleTableSegment)) continue;
            result.add(((SimpleTableSegment)each).getTableName().getIdentifier().getValue());
        }
        return result;
    }

    public String getType() {
        return "PostgreSQL";
    }
}

