/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.admin.opengauss;

import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.calcite.adapter.java.ReflectiveSchema;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.shardingsphere.infra.autogen.version.ShardingSphereVersion;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.metadata.JDBCQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.memory.JDBCMemoryQueryResult;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.opengauss.schema.OgCatalog;
import org.apache.shardingsphere.proxy.backend.handler.admin.opengauss.schema.OgDatabase;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sharding.merge.common.IteratorStreamMergedResult;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;

public final class OpenGaussSystemCatalogAdminQueryExecutor
implements DatabaseAdminQueryExecutor {
    private static final String PG_CATALOG = "pg_catalog";
    private static final String DAT_COMPATIBILITY = "PG";
    private final String sql;
    private QueryResultMetaData queryResultMetaData;
    private MergedResult mergedResult;

    public OpenGaussSystemCatalogAdminQueryExecutor(String sql) {
        this.sql = SQLUtil.trimSemicolon((String)sql);
    }

    @Override
    public void execute(ConnectionSession connectionSession) throws SQLException {
        try (CalciteConnection connection = DriverManager.getConnection("jdbc:calcite:caseSensitive=false").unwrap(CalciteConnection.class);){
            connection.getRootSchema().add(PG_CATALOG, (Schema)new ReflectiveSchema((Object)this.constructOgCatalog()));
            connection.getRootSchema().add("version", (Function)ScalarFunctionImpl.create(this.getClass(), (String)"version"));
            connection.getRootSchema().add("gs_password_deadline", (Function)ScalarFunctionImpl.create(this.getClass(), (String)"gsPasswordDeadline"));
            connection.getRootSchema().add("intervaltonum", (Function)ScalarFunctionImpl.create(this.getClass(), (String)"intervalToNum"));
            connection.getRootSchema().add("gs_password_notifyTime", (Function)ScalarFunctionImpl.create(this.getClass(), (String)"gsPasswordNotifyTime"));
            connection.setSchema(PG_CATALOG);
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery(this.sql);){
                this.queryResultMetaData = new JDBCQueryResultMetaData(resultSet.getMetaData());
                this.mergedResult = new IteratorStreamMergedResult(Collections.singletonList(new JDBCMemoryQueryResult(resultSet, connectionSession.getDatabaseType())));
            }
        }
    }

    private OgCatalog constructOgCatalog() {
        Collection<String> allDatabaseNames = ProxyContext.getInstance().getAllDatabaseNames();
        OgDatabase[] ogDatabases = new OgDatabase[allDatabaseNames.size()];
        int i = 0;
        for (String each : allDatabaseNames) {
            ogDatabases[i++] = new OgDatabase(each, DAT_COMPATIBILITY);
        }
        return new OgCatalog(ogDatabases);
    }

    public static String version() {
        return "ShardingSphere-Proxy 5.2.1" + "-" + ShardingSphereVersion.BUILD_GIT_COMMIT_ID_ABBREV + (ShardingSphereVersion.BUILD_GIT_DIRTY ? "-dirty" : "");
    }

    public static int gsPasswordDeadline() {
        return 90;
    }

    public static int intervalToNum(int result) {
        return result;
    }

    public static int gsPasswordNotifyTime() {
        return 7;
    }

    @Override
    @Generated
    public QueryResultMetaData getQueryResultMetaData() {
        return this.queryResultMetaData;
    }

    @Override
    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }
}

