/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.admin.opengauss;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutorCreator;
import org.apache.shardingsphere.proxy.backend.handler.admin.opengauss.OpenGaussSystemCatalogAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.postgresql.PostgreSQLAdminExecutorCreator;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class OpenGaussAdminExecutorCreator
implements DatabaseAdminExecutorCreator {
    private static final Set<String> SYSTEM_CATALOG_QUERY_EXPRESSIONS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private static final String OG_DATABASE = "pg_database";
    private final PostgreSQLAdminExecutorCreator delegated = new PostgreSQLAdminExecutorCreator();

    @Override
    public Optional<DatabaseAdminExecutor> create(SQLStatementContext<?> sqlStatementContext) {
        return this.delegated.create(sqlStatementContext);
    }

    @Override
    public Optional<DatabaseAdminExecutor> create(SQLStatementContext<?> sqlStatementContext, String sql, String databaseName) {
        if (this.isSystemCatalogQuery(sqlStatementContext)) {
            return Optional.of(new OpenGaussSystemCatalogAdminQueryExecutor(sql));
        }
        return this.delegated.create(sqlStatementContext, sql, databaseName);
    }

    private boolean isSystemCatalogQuery(SQLStatementContext<?> sqlStatementContext) {
        if (sqlStatementContext.getTablesContext().getTableNames().contains(OG_DATABASE)) {
            return true;
        }
        if (!(sqlStatementContext.getSqlStatement() instanceof SelectStatement)) {
            return false;
        }
        SelectStatement selectStatement = (SelectStatement)sqlStatementContext.getSqlStatement();
        Collection projections = selectStatement.getProjections().getProjections();
        return 1 == projections.size() && projections.iterator().next() instanceof ExpressionProjectionSegment && SYSTEM_CATALOG_QUERY_EXPRESSIONS.contains(((ExpressionProjectionSegment)projections.iterator().next()).getText());
    }

    public String getType() {
        return "openGauss";
    }

    static {
        SYSTEM_CATALOG_QUERY_EXPRESSIONS.add("VERSION()");
        SYSTEM_CATALOG_QUERY_EXPRESSIONS.add("intervaltonum(gs_password_deadline())");
        SYSTEM_CATALOG_QUERY_EXPRESSIONS.add("gs_password_notifytime()");
    }
}

