/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.admin.mysql.executor;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.dialect.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.executor.check.SQLCheckEngine;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.UseStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;

public final class UseDatabaseExecutor
implements DatabaseAdminExecutor {
    private final UseStatement useStatement;

    @Override
    public void execute(ConnectionSession connectionSession) {
        String databaseName = SQLUtil.getExactlyValue((String)this.useStatement.getSchema());
        if (ProxyContext.getInstance().databaseExists(databaseName) && SQLCheckEngine.check((String)databaseName, this.getRules(databaseName), (Grantee)connectionSession.getGrantee())) {
            connectionSession.setCurrentDatabase(databaseName);
            return;
        }
        throw new UnknownDatabaseException(databaseName);
    }

    private Collection<ShardingSphereRule> getRules(String databaseName) {
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>();
        Optional.ofNullable(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabase(databaseName)).ifPresent(optional -> result.addAll(optional.getRuleMetaData().getRules()));
        result.addAll(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getRules());
        return result;
    }

    @Generated
    public UseDatabaseExecutor(UseStatement useStatement) {
        this.useStatement = useStatement;
    }
}

