/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.admin.mysql.executor;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.check.SQLCheckEngine;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataMergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dal.ShowFilterSegment;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowDatabasesStatement;

public final class ShowDatabasesExecutor
implements DatabaseAdminQueryExecutor {
    private final MySQLShowDatabasesStatement showDatabasesStatement;
    private MergedResult mergedResult;

    @Override
    public void execute(ConnectionSession connectionSession) {
        this.mergedResult = new LocalDataMergedResult(this.getDatabaseNames(connectionSession));
    }

    private Collection<LocalDataQueryResultRow> getDatabaseNames(ConnectionSession connectionSession) {
        return ProxyContext.getInstance().getAllDatabaseNames().stream().filter(each -> this.checkLikePattern((String)each) && SQLCheckEngine.check((String)each, this.getRules((String)each), (Grantee)connectionSession.getGrantee())).map(xva$0 -> new LocalDataQueryResultRow(new Object[]{xva$0})).collect(Collectors.toList());
    }

    private boolean checkLikePattern(String databaseName) {
        if (this.showDatabasesStatement.getFilter().isPresent()) {
            Optional<String> pattern = ((ShowFilterSegment)this.showDatabasesStatement.getFilter().get()).getLike().map(optional -> SQLUtil.convertLikePatternToRegex((String)optional.getPattern()));
            return !pattern.isPresent() || databaseName.matches(pattern.get());
        }
        return true;
    }

    private Collection<ShardingSphereRule> getRules(String databaseName) {
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabase(databaseName).getRuleMetaData().getRules());
        result.addAll(ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getRules());
        return result;
    }

    @Override
    public QueryResultMetaData getQueryResultMetaData() {
        return new RawQueryResultMetaData(Collections.singletonList(new RawQueryResultColumnMetaData("SCHEMATA", "Database", "schema_name", 12, "VARCHAR", 255, 0)));
    }

    @Generated
    public ShowDatabasesExecutor(MySQLShowDatabasesStatement showDatabasesStatement) {
        this.showDatabasesStatement = showDatabasesStatement;
    }

    @Generated
    public MySQLShowDatabasesStatement getShowDatabasesStatement() {
        return this.showDatabasesStatement;
    }

    @Override
    @Generated
    public MergedResult getMergedResult() {
        return this.mergedResult;
    }
}

