/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.admin.mysql.executor;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.apache.shardingsphere.db.protocol.CommonConstants;
import org.apache.shardingsphere.db.protocol.mysql.constant.MySQLServerInfo;
import org.apache.shardingsphere.dialect.mysql.exception.UnknownCharsetException;
import org.apache.shardingsphere.proxy.backend.handler.admin.mysql.MySQLSessionVariableHandler;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;

public final class MySQLSetCharsetExecutor
implements MySQLSessionVariableHandler {
    private static final Set<String> TYPE_ALIASES = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);

    @Override
    public void handle(ConnectionSession connectionSession, String variableName, String assignValue) {
        String value = this.formatValue(assignValue);
        connectionSession.getAttributeMap().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).set((Object)this.parseCharset(value));
    }

    private String formatValue(String value) {
        return value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value.trim();
    }

    private Charset parseCharset(String value) {
        switch (value.toLowerCase(Locale.ROOT)) {
            case "default": {
                return MySQLServerInfo.DEFAULT_CHARSET.getCharset();
            }
            case "utf8mb4": {
                return StandardCharsets.UTF_8;
            }
        }
        try {
            return Charset.forName(value);
        }
        catch (Exception ex) {
            throw new UnknownCharsetException(value.toLowerCase());
        }
    }

    public String getType() {
        return "charset";
    }

    public Collection<String> getTypeAliases() {
        return TYPE_ALIASES;
    }

    static {
        TYPE_ALIASES.add("character_set_client");
    }
}

