/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.admin.mysql;

import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngineFactory;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.mysql.MySQLSessionVariableHandlerFactory;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dal.VariableAssignSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.SetStatement;

public final class MySQLSetVariableAdminExecutor
implements DatabaseAdminExecutor {
    private final SetStatement setStatement;

    @Override
    public void execute(ConnectionSession connectionSession) throws SQLException {
        Map<String, String> sessionVariables = this.extractSessionVariables();
        Map handlers = sessionVariables.keySet().stream().collect(Collectors.toMap(Function.identity(), MySQLSessionVariableHandlerFactory::getHandler));
        for (String each : handlers.keySet()) {
            handlers.get(each).handle(connectionSession, each, sessionVariables.get(each));
        }
        this.executeSetGlobalVariablesIfPresent(connectionSession);
    }

    private Map<String, String> extractSessionVariables() {
        return this.setStatement.getVariableAssigns().stream().filter(each -> !"global".equalsIgnoreCase(each.getVariable().getScope())).collect(Collectors.toMap(each -> each.getVariable().getVariable(), VariableAssignSegment::getAssignValue));
    }

    private Map<String, String> extractGlobalVariables() {
        return this.setStatement.getVariableAssigns().stream().filter(each -> "global".equalsIgnoreCase(each.getVariable().getScope())).collect(Collectors.toMap(each -> each.getVariable().getVariable(), VariableAssignSegment::getAssignValue, (oldValue, newValue) -> newValue, LinkedHashMap::new));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSetGlobalVariablesIfPresent(ConnectionSession connectionSession) throws SQLException {
        if (null == connectionSession.getDatabaseName()) {
            return;
        }
        String concatenatedGlobalVariables = this.extractGlobalVariables().entrySet().stream().map(entry -> String.format("@@GLOBAL.%s = %s", entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
        if (concatenatedGlobalVariables.isEmpty()) {
            return;
        }
        String sql = "SET " + concatenatedGlobalVariables;
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        SQLParserRule sqlParserRule = (SQLParserRule)metaDataContexts.getMetaData().getGlobalRuleMetaData().getSingleRule(SQLParserRule.class);
        SQLStatement sqlStatement = sqlParserRule.getSQLParserEngine(DatabaseTypeFactory.getInstance((String)"MySQL").getType()).parse(sql, false);
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance((Map)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabases(), (SQLStatement)sqlStatement, (String)connectionSession.getDefaultDatabaseName());
        try (Object databaseBackendHandler = DatabaseCommunicationEngineFactory.getInstance().newDatabaseCommunicationEngine(new QueryContext(sqlStatementContext, sql, Collections.emptyList()), connectionSession.getBackendConnection(), false);){
            databaseBackendHandler.execute();
        }
    }

    @Generated
    public MySQLSetVariableAdminExecutor(SetStatement setStatement) {
        this.setStatement = setStatement;
    }
}

