/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.admin.mysql;

import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutorCreator;
import org.apache.shardingsphere.proxy.backend.handler.admin.mysql.MySQLInformationSchemaExecutorFactory;
import org.apache.shardingsphere.proxy.backend.handler.admin.mysql.MySQLSetVariableAdminExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.mysql.executor.KillProcessExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.mysql.executor.NoResourceShowExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.mysql.executor.ShowConnectionIdExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.mysql.executor.ShowCreateDatabaseExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.mysql.executor.ShowCurrentDatabaseExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.mysql.executor.ShowCurrentUserExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.mysql.executor.ShowDatabasesExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.mysql.executor.ShowFunctionStatusExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.mysql.executor.ShowProcedureStatusExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.mysql.executor.ShowProcessListExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.mysql.executor.ShowTablesExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.mysql.executor.ShowTransactionExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.mysql.executor.ShowVersionExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.mysql.executor.UnicastResourceShowExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.mysql.executor.UseDatabaseExecutor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.SetStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.UseStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLKillStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowCreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowDatabasesStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowFunctionStatusStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowProcedureStatusStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowProcessListStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowTablesStatement;

public final class MySQLAdminExecutorCreator
implements DatabaseAdminExecutorCreator {
    private static final String INFORMATION_SCHEMA = "information_schema";
    private static final String PERFORMANCE_SCHEMA = "performance_schema";

    @Override
    public Optional<DatabaseAdminExecutor> create(SQLStatementContext<?> sqlStatementContext) {
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof MySQLShowFunctionStatusStatement) {
            return Optional.of(new ShowFunctionStatusExecutor((MySQLShowFunctionStatusStatement)sqlStatement));
        }
        if (sqlStatement instanceof MySQLShowProcedureStatusStatement) {
            return Optional.of(new ShowProcedureStatusExecutor((MySQLShowProcedureStatusStatement)sqlStatement));
        }
        if (sqlStatement instanceof MySQLShowTablesStatement) {
            return Optional.of(new ShowTablesExecutor((MySQLShowTablesStatement)sqlStatement, sqlStatementContext.getDatabaseType()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<DatabaseAdminExecutor> create(SQLStatementContext<?> sqlStatementContext, String sql, String databaseName) {
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        if (sqlStatement instanceof UseStatement) {
            return Optional.of(new UseDatabaseExecutor((UseStatement)sqlStatement));
        }
        if (sqlStatement instanceof MySQLShowDatabasesStatement) {
            return Optional.of(new ShowDatabasesExecutor((MySQLShowDatabasesStatement)sqlStatement));
        }
        if (sqlStatement instanceof MySQLShowProcessListStatement) {
            return Optional.of(new ShowProcessListExecutor());
        }
        if (sqlStatement instanceof MySQLKillStatement) {
            return Optional.of(new KillProcessExecutor((MySQLKillStatement)sqlStatement));
        }
        if (sqlStatement instanceof MySQLShowCreateDatabaseStatement) {
            return Optional.of(new ShowCreateDatabaseExecutor((MySQLShowCreateDatabaseStatement)sqlStatement));
        }
        if (sqlStatement instanceof SetStatement) {
            return Optional.of(new MySQLSetVariableAdminExecutor((SetStatement)sqlStatement));
        }
        if (sqlStatement instanceof SelectStatement) {
            SelectStatement selectStatement = (SelectStatement)sqlStatement;
            if (null == selectStatement.getFrom()) {
                return this.getSelectFunctionOrVariableExecutor(selectStatement, sql, databaseName);
            }
            if (this.isQueryInformationSchema(selectStatement)) {
                return MySQLInformationSchemaExecutorFactory.newInstance(selectStatement, sql);
            }
            if (this.isQueryPerformanceSchema(selectStatement)) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private Optional<DatabaseAdminExecutor> getSelectFunctionOrVariableExecutor(SelectStatement selectStatement, String sql, String databaseName) {
        if (this.isShowSpecialFunction(selectStatement, "connection_id()")) {
            return Optional.of(new ShowConnectionIdExecutor(selectStatement));
        }
        if (this.isShowSpecialFunction(selectStatement, "version()")) {
            return Optional.of(new ShowVersionExecutor(selectStatement));
        }
        if (this.isShowSpecialFunction(selectStatement, "current_user()") || this.isShowSpecialFunction(selectStatement, "current_user")) {
            return Optional.of(new ShowCurrentUserExecutor());
        }
        boolean hasNoResource = this.hasNoResource();
        if (hasNoResource && this.isShowSpecialFunction(selectStatement, "@@session.transaction_read_only")) {
            return Optional.of(new ShowTransactionExecutor("@@session.transaction_read_only"));
        }
        if (hasNoResource && this.isShowSpecialFunction(selectStatement, "@@session.transaction_isolation")) {
            return Optional.of(new ShowTransactionExecutor("@@session.transaction_isolation"));
        }
        if (this.isShowSpecialFunction(selectStatement, "DATABASE()")) {
            return Optional.of(new ShowCurrentDatabaseExecutor());
        }
        return this.mockExecutor(databaseName, selectStatement, sql);
    }

    private boolean isShowSpecialFunction(SelectStatement sqlStatement, String functionName) {
        Iterator segmentIterator = sqlStatement.getProjections().getProjections().iterator();
        ProjectionSegment firstProjection = (ProjectionSegment)segmentIterator.next();
        return !segmentIterator.hasNext() && firstProjection instanceof ExpressionProjectionSegment && functionName.equalsIgnoreCase(((ExpressionProjectionSegment)firstProjection).getText());
    }

    private boolean isQueryInformationSchema(SelectStatement sqlStatement) {
        return this.isQuerySpecialSchema(sqlStatement, INFORMATION_SCHEMA);
    }

    private boolean isQueryPerformanceSchema(SelectStatement sqlStatement) {
        return this.isQuerySpecialSchema(sqlStatement, PERFORMANCE_SCHEMA);
    }

    private boolean isQuerySpecialSchema(SelectStatement sqlStatement, String specialSchemaName) {
        TableSegment tableSegment = sqlStatement.getFrom();
        if (!(tableSegment instanceof SimpleTableSegment)) {
            return false;
        }
        return ((SimpleTableSegment)tableSegment).getOwner().isPresent() && specialSchemaName.equalsIgnoreCase(((OwnerSegment)((SimpleTableSegment)tableSegment).getOwner().get()).getIdentifier().getValue());
    }

    private Optional<DatabaseAdminExecutor> mockExecutor(String databaseName, SelectStatement sqlStatement, String sql) {
        boolean isNotUseSchema;
        boolean bl = isNotUseSchema = null == databaseName && null == sqlStatement.getFrom();
        if (this.hasNoResource()) {
            return Optional.of(new NoResourceShowExecutor(sqlStatement));
        }
        String driverType = (String)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_BACKEND_DRIVER_TYPE);
        return isNotUseSchema && !"ExperimentalVertx".equals(driverType) ? Optional.of(new UnicastResourceShowExecutor(sqlStatement, sql)) : Optional.empty();
    }

    private boolean hasNoResource() {
        Collection<String> databaseNames = ProxyContext.getInstance().getAllDatabaseNames();
        if (databaseNames.isEmpty()) {
            return true;
        }
        for (String each : databaseNames) {
            if (!ProxyContext.getInstance().getDatabase(each).containsDataSource()) continue;
            return false;
        }
        return true;
    }

    public String getType() {
        return "MySQL";
    }
}

