/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.admin;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeaderBuilderEngine;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;

public final class DatabaseAdminQueryBackendHandler
implements ProxyBackendHandler {
    private final ConnectionSession connectionSession;
    private final DatabaseAdminQueryExecutor executor;
    private QueryResultMetaData queryResultMetaData;
    private MergedResult mergedResult;

    @Override
    public ResponseHeader execute() throws SQLException {
        this.executor.execute(this.connectionSession);
        this.queryResultMetaData = this.executor.getQueryResultMetaData();
        this.mergedResult = this.executor.getMergedResult();
        return new QueryResponseHeader(this.createResponseHeader());
    }

    private List<QueryHeader> createResponseHeader() throws SQLException {
        ArrayList<QueryHeader> result = new ArrayList<QueryHeader>(this.queryResultMetaData.getColumnCount());
        ShardingSphereDatabase database = null == this.connectionSession.getDatabaseName() ? null : ProxyContext.getInstance().getDatabase(this.connectionSession.getDatabaseName());
        DatabaseType databaseType = null == database ? this.connectionSession.getDatabaseType() : database.getProtocolType();
        QueryHeaderBuilderEngine queryHeaderBuilderEngine = new QueryHeaderBuilderEngine(databaseType);
        for (int columnIndex = 1; columnIndex <= this.queryResultMetaData.getColumnCount(); ++columnIndex) {
            result.add(queryHeaderBuilderEngine.build(this.queryResultMetaData, database, columnIndex));
        }
        return result;
    }

    @Override
    public boolean next() throws SQLException {
        return this.mergedResult.next();
    }

    @Override
    public QueryResponseRow getRowData() throws SQLException {
        ArrayList<QueryResponseCell> result = new ArrayList<QueryResponseCell>(this.queryResultMetaData.getColumnCount());
        for (int columnIndex = 1; columnIndex <= this.queryResultMetaData.getColumnCount(); ++columnIndex) {
            result.add(new QueryResponseCell(this.queryResultMetaData.getColumnType(columnIndex), this.mergedResult.getValue(columnIndex, Object.class)));
        }
        return new QueryResponseRow(result);
    }

    @Generated
    public DatabaseAdminQueryBackendHandler(ConnectionSession connectionSession, DatabaseAdminQueryExecutor executor) {
        this.connectionSession = connectionSession;
        this.executor = executor;
    }
}

