/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.admin;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.admin.DatabaseAdminQueryBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.admin.DatabaseAdminUpdateBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutorCreator;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutorCreatorFactory;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;

public final class DatabaseAdminBackendHandlerFactory {
    public static Optional<ProxyBackendHandler> newInstance(DatabaseType databaseType, SQLStatementContext<?> sqlStatementContext, ConnectionSession connectionSession) {
        Optional<DatabaseAdminExecutorCreator> creator = DatabaseAdminExecutorCreatorFactory.findInstance(databaseType);
        if (!creator.isPresent()) {
            return Optional.empty();
        }
        Optional<DatabaseAdminExecutor> executor = creator.get().create(sqlStatementContext);
        return executor.map(optional -> DatabaseAdminBackendHandlerFactory.createProxyBackendHandler(sqlStatementContext, connectionSession, optional));
    }

    public static Optional<ProxyBackendHandler> newInstance(DatabaseType databaseType, SQLStatementContext<?> sqlStatementContext, ConnectionSession connectionSession, String sql) {
        Optional<DatabaseAdminExecutorCreator> executorFactory = DatabaseAdminExecutorCreatorFactory.findInstance(databaseType);
        if (!executorFactory.isPresent()) {
            return Optional.empty();
        }
        Optional<DatabaseAdminExecutor> executor = executorFactory.get().create(sqlStatementContext, sql, connectionSession.getDatabaseName());
        return executor.map(optional -> DatabaseAdminBackendHandlerFactory.createProxyBackendHandler(sqlStatementContext, connectionSession, optional));
    }

    private static ProxyBackendHandler createProxyBackendHandler(SQLStatementContext<?> sqlStatementContext, ConnectionSession connectionSession, DatabaseAdminExecutor executor) {
        if (executor instanceof DatabaseAdminQueryExecutor) {
            return new DatabaseAdminQueryBackendHandler(connectionSession, (DatabaseAdminQueryExecutor)executor);
        }
        return new DatabaseAdminUpdateBackendHandler(connectionSession, sqlStatementContext.getSqlStatement(), executor);
    }

    @Generated
    private DatabaseAdminBackendHandlerFactory() {
    }
}

