/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler;

import com.google.common.base.Strings;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.statement.DistSQLStatement;
import org.apache.shardingsphere.distsql.parser.statement.ral.QueryableRALStatement;
import org.apache.shardingsphere.distsql.parser.statement.rql.RQLStatement;
import org.apache.shardingsphere.distsql.parser.statement.rul.RULStatement;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.check.SQLCheckEngine;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.util.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.admin.DatabaseAdminBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.handler.data.DatabaseBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.handler.database.DatabaseOperateBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.handler.distsql.DistSQLBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.handler.extra.ExtraProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.skip.SkipBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.transaction.TransactionBackendHandlerFactory;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dal.FlushStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dcl.DCLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropDatabaseStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.EmptyStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.TCLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowCreateUserStatement;
import org.apache.shardingsphere.transaction.utils.AutoCommitUtils;

public final class ProxyBackendHandlerFactory {
    public static ProxyBackendHandler newInstance(DatabaseType databaseType, String sql, ConnectionSession connectionSession) throws SQLException {
        if (Strings.isNullOrEmpty((String)SQLUtil.trimComment((String)sql))) {
            return new SkipBackendHandler((SQLStatement)new EmptyStatement());
        }
        SQLParserRule sqlParserRule = (SQLParserRule)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(SQLParserRule.class);
        SQLStatement sqlStatement = sqlParserRule.getSQLParserEngine(ProxyBackendHandlerFactory.getProtocolType(databaseType, connectionSession).getType()).parse(sql, false);
        return ProxyBackendHandlerFactory.newInstance(databaseType, sql, sqlStatement, connectionSession);
    }

    public static ProxyBackendHandler newInstance(DatabaseType databaseType, String sql, SQLStatement sqlStatement, ConnectionSession connectionSession) throws SQLException {
        if (sqlStatement instanceof EmptyStatement) {
            return new SkipBackendHandler((SQLStatement)new EmptyStatement());
        }
        databaseType.handleRollbackOnly(connectionSession.getTransactionStatus().isRollbackOnly(), sqlStatement);
        ProxyBackendHandlerFactory.checkUnsupportedSQLStatement(sqlStatement);
        if (sqlStatement instanceof DistSQLStatement) {
            ProxyBackendHandlerFactory.checkUnsupportedDistSQLStatementInTransaction(sqlStatement, connectionSession);
            return DistSQLBackendHandlerFactory.newInstance((DistSQLStatement)sqlStatement, connectionSession);
        }
        SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance((Map)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabases(), (SQLStatement)sqlStatement, (String)connectionSession.getDefaultDatabaseName());
        QueryContext queryContext = new QueryContext(sqlStatementContext, sql, Collections.emptyList());
        connectionSession.setQueryContext(queryContext);
        return ProxyBackendHandlerFactory.newInstance(databaseType, queryContext, connectionSession, false);
    }

    public static ProxyBackendHandler newInstance(DatabaseType databaseType, QueryContext queryContext, ConnectionSession connectionSession, boolean preferPreparedStatement) throws SQLException {
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        SQLStatement sqlStatement = sqlStatementContext.getSqlStatement();
        String sql = queryContext.getSql();
        ProxyBackendHandlerFactory.handleAutoCommit(sqlStatement, connectionSession);
        if (sqlStatement instanceof TCLStatement) {
            return TransactionBackendHandlerFactory.newInstance((SQLStatementContext<? extends TCLStatement>)sqlStatementContext, sql, connectionSession);
        }
        Optional<ProxyBackendHandler> backendHandler = DatabaseAdminBackendHandlerFactory.newInstance(databaseType, sqlStatementContext, connectionSession, sql);
        if (backendHandler.isPresent()) {
            return backendHandler.get();
        }
        Optional<ExtraProxyBackendHandler> extraHandler = ProxyBackendHandlerFactory.findExtraProxyBackendHandler(sqlStatement);
        if (extraHandler.isPresent()) {
            return extraHandler.get();
        }
        Optional<ProxyBackendHandler> databaseOperateHandler = ProxyBackendHandlerFactory.findDatabaseOperateBackendHandler(sqlStatement, connectionSession);
        if (databaseOperateHandler.isPresent()) {
            return databaseOperateHandler.get();
        }
        String databaseName = sqlStatementContext.getTablesContext().getDatabaseName().isPresent() ? (String)sqlStatementContext.getTablesContext().getDatabaseName().get() : connectionSession.getDatabaseName();
        SQLCheckEngine.check((SQLStatementContext)sqlStatementContext, Collections.emptyList(), ProxyBackendHandlerFactory.getRules(databaseName), (String)databaseName, (Map)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabases(), (Grantee)connectionSession.getGrantee());
        backendHandler = DatabaseAdminBackendHandlerFactory.newInstance(databaseType, sqlStatementContext, connectionSession);
        return backendHandler.orElseGet(() -> DatabaseBackendHandlerFactory.newInstance(queryContext, connectionSession, preferPreparedStatement));
    }

    private static void checkUnsupportedDistSQLStatementInTransaction(SQLStatement sqlStatement, ConnectionSession connectionSession) {
        ShardingSpherePreconditions.checkState((!connectionSession.getTransactionStatus().isInTransaction() || ProxyBackendHandlerFactory.isSupportedDistSQLStatementInTransaction(sqlStatement) ? 1 : 0) != 0, () -> new UnsupportedSQLOperationException("Non-query dist sql is not supported within a transaction"));
    }

    private static boolean isSupportedDistSQLStatementInTransaction(SQLStatement sqlStatement) {
        return sqlStatement instanceof RQLStatement || sqlStatement instanceof QueryableRALStatement || sqlStatement instanceof RULStatement;
    }

    private static DatabaseType getProtocolType(DatabaseType defaultDatabaseType, ConnectionSession connectionSession) {
        String databaseName = connectionSession.getDatabaseName();
        return Strings.isNullOrEmpty((String)databaseName) || !ProxyContext.getInstance().databaseExists(databaseName) ? defaultDatabaseType : ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabase(databaseName).getProtocolType();
    }

    private static void handleAutoCommit(SQLStatement sqlStatement, ConnectionSession connectionSession) {
        if (AutoCommitUtils.needOpenTransaction((SQLStatement)sqlStatement)) {
            connectionSession.getBackendConnection().handleAutoCommit();
        }
    }

    private static Optional<ExtraProxyBackendHandler> findExtraProxyBackendHandler(SQLStatement sqlStatement) {
        for (ExtraProxyBackendHandler each : ShardingSphereServiceLoader.getServiceInstances(ExtraProxyBackendHandler.class)) {
            if (!each.accept(sqlStatement)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    private static Optional<ProxyBackendHandler> findDatabaseOperateBackendHandler(SQLStatement sqlStatement, ConnectionSession connectionSession) {
        if (sqlStatement instanceof CreateDatabaseStatement || sqlStatement instanceof DropDatabaseStatement) {
            return Optional.of(DatabaseOperateBackendHandlerFactory.newInstance(sqlStatement, connectionSession));
        }
        return Optional.empty();
    }

    private static Collection<ShardingSphereRule> getRules(String databaseName) {
        MetaDataContexts contexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        if (Strings.isNullOrEmpty((String)databaseName) || !ProxyContext.getInstance().databaseExists(databaseName)) {
            return contexts.getMetaData().getGlobalRuleMetaData().getRules();
        }
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>(contexts.getMetaData().getDatabase(databaseName).getRuleMetaData().getRules());
        result.addAll(contexts.getMetaData().getGlobalRuleMetaData().getRules());
        return result;
    }

    private static void checkUnsupportedSQLStatement(SQLStatement sqlStatement) {
        if (sqlStatement instanceof DCLStatement || sqlStatement instanceof FlushStatement || sqlStatement instanceof MySQLShowCreateUserStatement) {
            throw new UnsupportedSQLOperationException("Unsupported operation");
        }
    }

    @Generated
    private ProxyBackendHandlerFactory() {
    }

    static {
        ShardingSphereServiceLoader.register(ExtraProxyBackendHandler.class);
    }
}

