/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler;

import java.sql.SQLException;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.dialect.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.dialect.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.available.FromDatabaseAvailable;

public abstract class DatabaseRequiredBackendHandler<T extends SQLStatement>
implements ProxyBackendHandler {
    private final T sqlStatement;
    private final ConnectionSession connectionSession;

    @Override
    public final ResponseHeader execute() throws SQLException {
        String databaseName = this.getDatabaseName(this.connectionSession, this.sqlStatement);
        this.checkDatabaseName(databaseName);
        return this.execute(databaseName, this.sqlStatement);
    }

    protected abstract ResponseHeader execute(String var1, T var2);

    private String getDatabaseName(ConnectionSession connectionSession, T sqlStatement) {
        Optional databaseSegment = sqlStatement instanceof FromDatabaseAvailable ? ((FromDatabaseAvailable)sqlStatement).getDatabase() : Optional.empty();
        return databaseSegment.isPresent() ? ((DatabaseSegment)databaseSegment.get()).getIdentifier().getValue() : connectionSession.getDatabaseName();
    }

    private void checkDatabaseName(String databaseName) {
        ShardingSpherePreconditions.checkNotNull((Object)databaseName, NoDatabaseSelectedException::new);
        ShardingSpherePreconditions.checkState((boolean)ProxyContext.getInstance().databaseExists(databaseName), () -> new UnknownDatabaseException(databaseName));
    }

    @Generated
    public DatabaseRequiredBackendHandler(T sqlStatement, ConnectionSession connectionSession) {
        this.sqlStatement = sqlStatement;
        this.connectionSession = connectionSession;
    }

    @Generated
    public T getSqlStatement() {
        return this.sqlStatement;
    }

    @Generated
    public ConnectionSession getConnectionSession() {
        return this.connectionSession;
    }
}

