/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.config;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.authority.yaml.config.YamlAuthorityRuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperFactory;
import org.apache.shardingsphere.proxy.backend.config.YamlProxyConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyDatabaseConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyServerConfiguration;

public final class ProxyConfigurationLoader {
    private static final String SERVER_CONFIG_FILE = "server.yaml";
    private static final Pattern SCHEMA_CONFIG_FILE_PATTERN = Pattern.compile("config-.+\\.yaml");

    public static YamlProxyConfiguration load(String path) throws IOException {
        YamlProxyServerConfiguration serverConfig = ProxyConfigurationLoader.loadServerConfiguration(ProxyConfigurationLoader.getResourceFile(String.join((CharSequence)"/", path, SERVER_CONFIG_FILE)));
        File configPath = ProxyConfigurationLoader.getResourceFile(path);
        Collection<YamlProxyDatabaseConfiguration> databaseConfigs = ProxyConfigurationLoader.loadDatabaseConfigurations(configPath);
        return new YamlProxyConfiguration(serverConfig, databaseConfigs.stream().collect(Collectors.toMap(YamlProxyDatabaseConfiguration::getDatabaseName, each -> each, (oldValue, currentValue) -> oldValue, LinkedHashMap::new)));
    }

    private static File getResourceFile(String path) {
        URL url = ProxyConfigurationLoader.class.getResource(path);
        return null == url ? new File(path) : new File(url.toURI().getPath());
    }

    private static YamlProxyServerConfiguration loadServerConfiguration(File yamlFile) throws IOException {
        boolean containsGovernance;
        YamlProxyServerConfiguration result = (YamlProxyServerConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlProxyServerConfiguration.class);
        Preconditions.checkNotNull((Object)result, (String)"Server configuration file `%s` is invalid.", (Object)yamlFile.getName());
        boolean bl = containsGovernance = null != result.getMode() && "Cluster".equals(result.getMode().getType());
        if (null != result.getAuthority()) {
            result.getRules().removeIf(each -> each instanceof YamlAuthorityRuleConfiguration);
            result.getRules().add((YamlRuleConfiguration)result.getAuthority().convertToYamlAuthorityRuleConfiguration());
        }
        YamlRuleConfiguration authorityRuleConfig = result.getRules().stream().filter(each -> each instanceof YamlAuthorityRuleConfiguration).findAny().orElse(null);
        Preconditions.checkState((containsGovernance || null != authorityRuleConfig ? 1 : 0) != 0, (Object)"Authority configuration is invalid.");
        return result;
    }

    private static Collection<YamlProxyDatabaseConfiguration> loadDatabaseConfigurations(File configPath) throws IOException {
        HashSet loadedDatabaseNames = new HashSet();
        LinkedList<YamlProxyDatabaseConfiguration> result = new LinkedList<YamlProxyDatabaseConfiguration>();
        for (File each : ProxyConfigurationLoader.findRuleConfigurationFiles(configPath)) {
            ProxyConfigurationLoader.loadDatabaseConfiguration(each).ifPresent(optional -> {
                Preconditions.checkState((boolean)loadedDatabaseNames.add(optional.getDatabaseName()), (String)"Database name `%s` must unique at all database configurations.", (Object)optional.getDatabaseName());
                result.add((YamlProxyDatabaseConfiguration)optional);
            });
        }
        return result;
    }

    private static Optional<YamlProxyDatabaseConfiguration> loadDatabaseConfiguration(File yamlFile) throws IOException {
        YamlProxyDatabaseConfiguration result = (YamlProxyDatabaseConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlProxyDatabaseConfiguration.class);
        if (null == result) {
            return Optional.empty();
        }
        if (null == result.getDatabaseName()) {
            result.setDatabaseName(result.getSchemaName());
        }
        Preconditions.checkNotNull((Object)result.getDatabaseName(), (String)"Property `databaseName` in file `%s` is required.", (Object)yamlFile.getName());
        ProxyConfigurationLoader.checkDuplicateRule(result.getRules(), yamlFile);
        return Optional.of(result);
    }

    private static void checkDuplicateRule(Collection<YamlRuleConfiguration> ruleConfigurations, File yamlFile) {
        if (ruleConfigurations.isEmpty()) {
            return;
        }
        Map<Class, Long> ruleConfigTypeCountMap = ruleConfigurations.stream().collect(Collectors.groupingBy(YamlRuleConfiguration::getRuleConfigurationType, Collectors.counting()));
        Optional<Map.Entry> duplicateRuleConfig = ruleConfigTypeCountMap.entrySet().stream().filter(each -> (Long)each.getValue() > 1L).findFirst();
        if (duplicateRuleConfig.isPresent()) {
            throw new IllegalStateException(String.format("Duplicate rule tag `!%s` in file `%s`", ProxyConfigurationLoader.getDuplicateRuleTagName((Class)duplicateRuleConfig.get().getKey()), yamlFile.getName()));
        }
    }

    private static Object getDuplicateRuleTagName(Class<? extends RuleConfiguration> ruleConfigClass) {
        Optional<YamlRuleConfigurationSwapper> result = YamlRuleConfigurationSwapperFactory.getAllInstances().stream().filter(each -> ruleConfigClass.equals(each.getTypeClass())).findFirst();
        return result.orElseThrow(() -> new IllegalStateException("Not find rule tag name of class " + ruleConfigClass));
    }

    private static File[] findRuleConfigurationFiles(File path) {
        return path.listFiles(each -> SCHEMA_CONFIG_FILE_PATTERN.matcher(each.getName()).matches());
    }

    @Generated
    private ProxyConfigurationLoader() {
    }
}

