/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.vertx.executor;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.vertx.VertxExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.vertx.VertxExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.vertx.VertxExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.process.ExecuteProcessEngine;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;

public final class ProxyReactiveExecutor {
    private final VertxExecutor vertxExecutor;

    public Future<List<ExecuteResult>> execute(QueryContext queryContext, ExecutionGroupContext<VertxExecutionUnit> executionGroupContext) {
        EventBusContext eventBusContext = ProxyContext.getInstance().getContextManager().getInstanceContext().getEventBusContext();
        ExecuteProcessEngine.initializeExecution((QueryContext)queryContext, executionGroupContext, (EventBusContext)eventBusContext);
        List futures = this.vertxExecutor.execute(executionGroupContext, new VertxExecutorCallback());
        return CompositeFuture.all(new ArrayList(futures)).compose(compositeFuture -> {
            ExecuteProcessEngine.finishExecution((String)executionGroupContext.getExecutionID(), (EventBusContext)eventBusContext);
            return Future.succeededFuture((Object)compositeFuture.list());
        }).eventually(unused -> {
            ExecuteProcessEngine.cleanExecution();
            return Future.succeededFuture();
        });
    }

    @Generated
    public ProxyReactiveExecutor(VertxExecutor vertxExecutor) {
        this.vertxExecutor = vertxExecutor;
    }
}

