/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.jdbc.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.proxy.backend.communication.TransactionManager;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.JDBCBackendConnection;
import org.apache.shardingsphere.transaction.ConnectionSavepointManager;

public final class LocalTransactionManager
implements TransactionManager<Void> {
    private final JDBCBackendConnection connection;

    @Override
    public Void begin() {
        this.connection.getConnectionPostProcessors().add(target -> {
            try {
                target.setAutoCommit(false);
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        });
        return null;
    }

    @Override
    public Void commit() throws SQLException {
        LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
        if (this.connection.getConnectionSession().getTransactionStatus().isRollbackOnly()) {
            exceptions.addAll(this.rollbackConnections());
        } else {
            exceptions.addAll(this.commitConnections());
        }
        this.throwSQLExceptionIfNecessary(exceptions);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<SQLException> commitConnections() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Connection each : this.connection.getCachedConnections().values()) {
            try {
                each.commit();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
            finally {
                ConnectionSavepointManager.getInstance().transactionFinished(each);
            }
        }
        return result;
    }

    @Override
    public Void rollback() throws SQLException {
        if (this.connection.getConnectionSession().getTransactionStatus().isInTransaction()) {
            LinkedList<SQLException> exceptions = new LinkedList<SQLException>(this.rollbackConnections());
            this.throwSQLExceptionIfNecessary(exceptions);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<SQLException> rollbackConnections() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Connection each : this.connection.getCachedConnections().values()) {
            try {
                each.rollback();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
            finally {
                ConnectionSavepointManager.getInstance().transactionFinished(each);
            }
        }
        return result;
    }

    @Override
    public Void setSavepoint(String savepointName) {
        return null;
    }

    @Override
    public Void rollbackTo(String savepointName) {
        return null;
    }

    @Override
    public Void releaseSavepoint(String savepointName) {
        return null;
    }

    private Void throwSQLExceptionIfNecessary(Collection<SQLException> exceptions) throws SQLException {
        if (exceptions.isEmpty()) {
            return null;
        }
        SQLException ex = null;
        int count = 0;
        for (SQLException each : exceptions) {
            if (0 == count) {
                ex = each;
            } else {
                ex.setNextException(each);
            }
            ++count;
        }
        throw ex;
    }

    @Generated
    public LocalTransactionManager(JDBCBackendConnection connection) {
        this.connection = connection;
    }
}

