/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.jdbc.statement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.db.protocol.parameter.TypeUnspecifiedSQLParameter;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.DatabaseTypeAware;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.ExecutorJDBCStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.statement.StatementMemoryStrictlyFetchSizeSetter;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.statement.StatementMemoryStrictlyFetchSizeSetterFactory;

public final class JDBCBackendStatement
implements ExecutorJDBCStatementManager,
DatabaseTypeAware {
    private DatabaseType databaseType;

    public Statement createStorageResource(Connection connection, ConnectionMode connectionMode, StatementOption option) throws SQLException {
        Statement result = connection.createStatement();
        if (ConnectionMode.MEMORY_STRICTLY == connectionMode) {
            this.setFetchSize(result);
        }
        return result;
    }

    public Statement createStorageResource(ExecutionUnit executionUnit, Connection connection, ConnectionMode connectionMode, StatementOption option) throws SQLException {
        String sql = executionUnit.getSqlUnit().getSql();
        List parameters = executionUnit.getSqlUnit().getParameters();
        PreparedStatement result = option.isReturnGeneratedKeys() ? connection.prepareStatement(executionUnit.getSqlUnit().getSql(), 1) : connection.prepareStatement(sql);
        for (int i = 0; i < parameters.size(); ++i) {
            Object parameter = parameters.get(i);
            if (parameter instanceof TypeUnspecifiedSQLParameter) {
                result.setObject(i + 1, parameter, 1111);
                continue;
            }
            result.setObject(i + 1, parameter);
        }
        if (ConnectionMode.MEMORY_STRICTLY == connectionMode) {
            this.setFetchSize(result);
        }
        return result;
    }

    private void setFetchSize(Statement statement) throws SQLException {
        Optional<StatementMemoryStrictlyFetchSizeSetter> fetchSizeSetter = StatementMemoryStrictlyFetchSizeSetterFactory.findInstance(this.databaseType.getType());
        if (fetchSizeSetter.isPresent()) {
            fetchSizeSetter.get().setFetchSize(statement);
        }
    }

    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public void setDatabaseType(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }
}

