/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.jdbc.executor.callback;

import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.util.exception.external.sql.type.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.JDBCDatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.executor.callback.ProxyJDBCExecutorCallback;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.executor.callback.impl.ProxyPreparedStatementExecutorCallback;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.executor.callback.impl.ProxyStatementExecutorCallback;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ProxyJDBCExecutorCallbackFactory {
    public static ProxyJDBCExecutorCallback newInstance(String type, DatabaseType protocolType, DatabaseType databaseType, SQLStatement sqlStatement, JDBCDatabaseCommunicationEngine databaseCommunicationEngine, boolean isReturnGeneratedKeys, boolean isExceptionThrown, boolean isFetchMetaData) {
        if ("JDBC.STATEMENT".equals(type)) {
            return new ProxyStatementExecutorCallback(protocolType, databaseType, sqlStatement, databaseCommunicationEngine, isReturnGeneratedKeys, isExceptionThrown, isFetchMetaData);
        }
        if ("JDBC.PREPARED_STATEMENT".equals(type)) {
            return new ProxyPreparedStatementExecutorCallback(protocolType, databaseType, sqlStatement, databaseCommunicationEngine, isReturnGeneratedKeys, isExceptionThrown, isFetchMetaData);
        }
        throw new UnsupportedSQLOperationException(String.format("Unsupported driver type: `%s`", type));
    }

    @Generated
    private ProxyJDBCExecutorCallbackFactory() {
    }
}

