/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.jdbc.executor.callback;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.sane.SaneQueryResultEngineFactory;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.memory.JDBCMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.stream.JDBCStreamQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.JDBCDatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public abstract class ProxyJDBCExecutorCallback
extends JDBCExecutorCallback<ExecuteResult> {
    private final JDBCDatabaseCommunicationEngine databaseCommunicationEngine;
    private final boolean isReturnGeneratedKeys;
    private final boolean fetchMetaData;
    private boolean hasMetaData;

    public ProxyJDBCExecutorCallback(DatabaseType protocolType, DatabaseType databaseType, SQLStatement sqlStatement, JDBCDatabaseCommunicationEngine databaseCommunicationEngine, boolean isReturnGeneratedKeys, boolean isExceptionThrown, boolean fetchMetaData) {
        super(protocolType, databaseType, sqlStatement, isExceptionThrown, ProxyContext.getInstance().getContextManager().getInstanceContext().getEventBusContext());
        this.databaseCommunicationEngine = databaseCommunicationEngine;
        this.isReturnGeneratedKeys = isReturnGeneratedKeys;
        this.fetchMetaData = fetchMetaData;
    }

    public ExecuteResult executeSQL(String sql, Statement statement, ConnectionMode connectionMode) throws SQLException {
        if (this.fetchMetaData && !this.hasMetaData) {
            this.hasMetaData = true;
            return this.executeSQL(sql, statement, connectionMode, true);
        }
        return this.executeSQL(sql, statement, connectionMode, false);
    }

    private ExecuteResult executeSQL(String sql, Statement statement, ConnectionMode connectionMode, boolean withMetaData) throws SQLException {
        this.databaseCommunicationEngine.add(statement);
        if (this.execute(sql, statement, this.isReturnGeneratedKeys)) {
            ResultSet resultSet = statement.getResultSet();
            this.databaseCommunicationEngine.add(resultSet);
            return this.createQueryResult(resultSet, connectionMode);
        }
        return new UpdateResult(statement.getUpdateCount(), this.isReturnGeneratedKeys ? this.getGeneratedKey(statement) : 0L);
    }

    protected abstract boolean execute(String var1, Statement var2, boolean var3) throws SQLException;

    private QueryResult createQueryResult(ResultSet resultSet, ConnectionMode connectionMode) throws SQLException {
        return ConnectionMode.MEMORY_STRICTLY == connectionMode ? new JDBCStreamQueryResult(resultSet) : new JDBCMemoryQueryResult(resultSet, this.getDatabaseType());
    }

    private long getGeneratedKey(Statement statement) throws SQLException {
        ResultSet resultSet = statement.getGeneratedKeys();
        return resultSet.next() ? this.getGeneratedKeyIfInteger(resultSet) : 0L;
    }

    private long getGeneratedKeyIfInteger(ResultSet resultSet) throws SQLException {
        switch (resultSet.getMetaData().getColumnType(1)) {
            case -5: 
            case 4: 
            case 5: {
                return resultSet.getLong(1);
            }
        }
        return 0L;
    }

    protected final Optional<ExecuteResult> getSaneResult(SQLStatement sqlStatement, SQLException ex) {
        return SaneQueryResultEngineFactory.getInstance((DatabaseType)this.getProtocolTypeType()).getSaneQueryResult(sqlStatement, ex);
    }

    private DatabaseType getProtocolTypeType() {
        Optional<DatabaseType> configuredDatabaseType = ProxyJDBCExecutorCallback.findConfiguredDatabaseType();
        if (configuredDatabaseType.isPresent()) {
            return configuredDatabaseType.get();
        }
        if (ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabases().isEmpty()) {
            return DatabaseTypeEngine.getTrunkDatabaseType((String)"MySQL");
        }
        return ((ShardingSphereDatabase)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabases().values().iterator().next()).getProtocolType();
    }

    private static Optional<DatabaseType> findConfiguredDatabaseType() {
        String configuredDatabaseType = (String)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_FRONTEND_DATABASE_PROTOCOL_TYPE);
        return configuredDatabaseType.isEmpty() ? Optional.empty() : Optional.of(DatabaseTypeEngine.getTrunkDatabaseType((String)configuredDatabaseType));
    }
}

