/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.jdbc.connection;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.ExecutorJDBCConnectionManager;
import org.apache.shardingsphere.proxy.backend.communication.BackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.ConnectionPostProcessor;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.ResourceLock;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.transaction.JDBCBackendTransactionManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.BackendConnectionException;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.util.TransactionUtil;
import org.apache.shardingsphere.transaction.core.TransactionType;

public final class JDBCBackendConnection
implements BackendConnection<Void>,
ExecutorJDBCConnectionManager {
    private final ConnectionSession connectionSession;
    private final Multimap<String, Connection> cachedConnections = LinkedHashMultimap.create();
    private final Collection<ProxyBackendHandler> backendHandlers = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private final Collection<ProxyBackendHandler> inUseBackendHandlers = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private final Collection<ConnectionPostProcessor<Connection>> connectionPostProcessors = new LinkedList<ConnectionPostProcessor<Connection>>();
    private final ResourceLock resourceLock = new ResourceLock();
    private final AtomicBoolean closed = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Connection> getConnections(String dataSourceName, int connectionSize, ConnectionMode connectionMode) throws SQLException {
        List<Connection> result;
        Collection connections;
        Preconditions.checkNotNull((Object)this.connectionSession.getDatabaseName(), (Object)"Current database name is null.");
        Multimap<String, Connection> multimap = this.cachedConnections;
        synchronized (multimap) {
            connections = this.cachedConnections.get((Object)(this.connectionSession.getDatabaseName().toLowerCase() + "." + dataSourceName));
        }
        if (connections.size() >= connectionSize) {
            result = new ArrayList(connections).subList(0, connectionSize);
        } else {
            if (!connections.isEmpty()) {
                result = new ArrayList(connectionSize);
                result.addAll(connections);
                List<Connection> newConnections = this.createNewConnections(dataSourceName, connectionSize - connections.size(), connectionMode);
                result.addAll(newConnections);
                Multimap<String, Connection> multimap2 = this.cachedConnections;
                synchronized (multimap2) {
                    this.cachedConnections.putAll((Object)(this.connectionSession.getDatabaseName().toLowerCase() + "." + dataSourceName), newConnections);
                }
            }
            result = this.createNewConnections(dataSourceName, connectionSize, connectionMode);
            Multimap<String, Connection> multimap3 = this.cachedConnections;
            synchronized (multimap3) {
                this.cachedConnections.putAll((Object)(this.connectionSession.getDatabaseName().toLowerCase() + "." + dataSourceName), result);
            }
        }
        return result;
    }

    private List<Connection> createNewConnections(String dataSourceName, int connectionSize, ConnectionMode connectionMode) throws SQLException {
        List<Connection> result = ProxyContext.getInstance().getBackendDataSource().getConnections(this.connectionSession.getDatabaseName().toLowerCase(), dataSourceName, connectionSize, connectionMode);
        this.setSessionVariablesIfNecessary(result);
        for (Connection each : result) {
            this.replayTransactionOption(each);
        }
        if (this.connectionSession.getTransactionStatus().isInTransaction()) {
            for (Connection each : result) {
                this.replayMethodsInvocation(each);
            }
        }
        return result;
    }

    private void setSessionVariablesIfNecessary(List<Connection> connections) throws SQLException {
        if (this.connectionSession.getRequiredSessionVariableRecorder().isEmpty() || connections.isEmpty()) {
            return;
        }
        String databaseType = connections.iterator().next().getMetaData().getDatabaseProductName();
        List<String> setSQLs = this.connectionSession.getRequiredSessionVariableRecorder().toSetSQLs(databaseType);
        SQLException sqlException = null;
        for (Connection each : connections) {
            try {
                Statement statement = each.createStatement();
                Throwable throwable = null;
                try {
                    for (String eachSetSQL : setSQLs) {
                        statement.execute(eachSetSQL);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
            catch (SQLException ex) {
                sqlException = ex;
                break;
            }
        }
        if (null == sqlException) {
            return;
        }
        for (Connection each : connections) {
            try {
                each.close();
            }
            catch (SQLException ex) {
                sqlException.setNextException(ex);
            }
        }
        throw sqlException;
    }

    private void replayMethodsInvocation(Connection target) {
        for (ConnectionPostProcessor<Connection> each : this.connectionPostProcessors) {
            each.process(target);
        }
    }

    private void replayTransactionOption(Connection connection) throws SQLException {
        if (null == connection) {
            return;
        }
        if (this.connectionSession.isReadOnly()) {
            connection.setReadOnly(true);
        }
        if (null != this.connectionSession.getIsolationLevel()) {
            connection.setTransactionIsolation(TransactionUtil.getTransactionIsolationLevel(this.connectionSession.getIsolationLevel()));
        }
    }

    public Collection<String> getDataSourceNamesOfCachedConnections() {
        ArrayList<String> result = new ArrayList<String>(this.cachedConnections.size());
        String databaseName = this.connectionSession.getDatabaseName().toLowerCase();
        for (String each : this.cachedConnections.keySet()) {
            String[] split = each.split("\\.", 2);
            String cachedDatabaseName = split[0];
            String cachedDataSourceName = split[1];
            if (!databaseName.equals(cachedDatabaseName)) continue;
            result.add(cachedDataSourceName);
        }
        return result;
    }

    public boolean isSerialExecute() {
        return this.connectionSession.getTransactionStatus().isInTransaction() && (TransactionType.LOCAL == this.connectionSession.getTransactionStatus().getTransactionType() || TransactionType.XA == this.connectionSession.getTransactionStatus().getTransactionType());
    }

    public int getConnectionSize() {
        return this.cachedConnections.values().size();
    }

    public void add(ProxyBackendHandler handler) {
        this.backendHandlers.add(handler);
    }

    public void markResourceInUse(ProxyBackendHandler handler) {
        this.inUseBackendHandlers.add(handler);
    }

    public void unmarkResourceInUse(ProxyBackendHandler handler) {
        this.inUseBackendHandlers.remove(handler);
    }

    @Override
    public Void prepareForTaskExecution() {
        return null;
    }

    @Override
    public Void handleAutoCommit() {
        if (!this.connectionSession.isAutoCommit() && !this.connectionSession.getTransactionStatus().isInTransaction()) {
            JDBCBackendTransactionManager transactionManager = new JDBCBackendTransactionManager(this);
            transactionManager.begin();
        }
        return null;
    }

    @Override
    public Void closeExecutionResources() throws BackendConnectionException {
        JDBCBackendConnection jDBCBackendConnection = this;
        synchronized (jDBCBackendConnection) {
            LinkedList<Exception> result = new LinkedList<Exception>(this.closeHandlers(false));
            if (!this.connectionSession.getTransactionStatus().isInConnectionHeldTransaction()) {
                result.addAll(this.closeHandlers(true));
                result.addAll(this.closeConnections(false));
            } else if (this.closed.get()) {
                result.addAll(this.closeHandlers(true));
                result.addAll(this.closeConnections(true));
            }
            if (result.isEmpty()) {
                return null;
            }
            throw new BackendConnectionException(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void closeAllResources() {
        JDBCBackendConnection jDBCBackendConnection = this;
        synchronized (jDBCBackendConnection) {
            this.closed.set(true);
            this.closeHandlers(true);
            this.closeConnections(true);
            return null;
        }
    }

    public Collection<SQLException> closeHandlers(boolean includeInUse) {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (ProxyBackendHandler each : this.backendHandlers) {
            if (!includeInUse && this.inUseBackendHandlers.contains(each)) continue;
            try {
                each.close();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        if (includeInUse) {
            this.inUseBackendHandlers.clear();
        }
        this.backendHandlers.retainAll(this.inUseBackendHandlers);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SQLException> closeConnections(boolean forceRollback) {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        Multimap<String, Connection> multimap = this.cachedConnections;
        synchronized (multimap) {
            this.resetSessionVariablesIfNecessary(this.cachedConnections.values(), result);
            for (Connection each : this.cachedConnections.values()) {
                try {
                    if (forceRollback && this.connectionSession.getTransactionStatus().isInTransaction()) {
                        each.rollback();
                    }
                    each.close();
                }
                catch (SQLException ex) {
                    result.add(ex);
                }
            }
            this.cachedConnections.clear();
        }
        if (!forceRollback) {
            this.connectionPostProcessors.clear();
        }
        return result;
    }

    private void resetSessionVariablesIfNecessary(Collection<Connection> values, Collection<SQLException> exceptions) {
        String databaseType;
        if (this.connectionSession.getRequiredSessionVariableRecorder().isEmpty() || values.isEmpty()) {
            return;
        }
        try {
            databaseType = values.iterator().next().getMetaData().getDatabaseProductName();
        }
        catch (SQLException ex) {
            exceptions.add(ex);
            return;
        }
        List<String> resetSQLs = this.connectionSession.getRequiredSessionVariableRecorder().toResetSQLs(databaseType);
        for (Connection each : values) {
            try {
                Statement statement = each.createStatement();
                Throwable throwable = null;
                try {
                    for (String eachResetSQL : resetSQLs) {
                        statement.execute(eachResetSQL);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
            catch (SQLException ex) {
                exceptions.add(ex);
            }
        }
        this.connectionSession.getRequiredSessionVariableRecorder().removeVariablesWithDefaultValue();
    }

    @Generated
    public JDBCBackendConnection(ConnectionSession connectionSession) {
        this.connectionSession = connectionSession;
    }

    @Override
    @Generated
    public ConnectionSession getConnectionSession() {
        return this.connectionSession;
    }

    @Generated
    public Multimap<String, Connection> getCachedConnections() {
        return this.cachedConnections;
    }

    @Generated
    public Collection<ProxyBackendHandler> getBackendHandlers() {
        return this.backendHandlers;
    }

    @Generated
    public Collection<ProxyBackendHandler> getInUseBackendHandlers() {
        return this.inUseBackendHandlers;
    }

    @Generated
    public Collection<ConnectionPostProcessor<Connection>> getConnectionPostProcessors() {
        return this.connectionPostProcessors;
    }

    @Generated
    public ResourceLock getResourceLock() {
        return this.resourceLock;
    }

    @Generated
    public AtomicBoolean getClosed() {
        return this.closed;
    }
}

