/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.binder.decider.context.SQLFederationDeciderContext;
import org.apache.shardingsphere.infra.binder.decider.engine.SQLFederationDeciderEngine;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.SQLExecutorExceptionHandler;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.metadata.JDBCQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.stream.JDBCStreamQueryResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorConnectionManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.jdbc.StatementOption;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.communication.ProxySQLExecutor;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.JDBCBackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.executor.callback.ProxyJDBCExecutorCallback;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.executor.callback.ProxyJDBCExecutorCallbackFactory;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.statement.JDBCBackendStatement;
import org.apache.shardingsphere.proxy.backend.context.BackendExecutorContext;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeaderBuilderEngine;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.sharding.merge.common.IteratorStreamMergedResult;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLInsertStatement;
import org.apache.shardingsphere.sqlfederation.rule.SQLFederationRule;
import org.apache.shardingsphere.sqlfederation.spi.SQLFederationExecutor;
import org.apache.shardingsphere.sqlfederation.spi.SQLFederationExecutorContext;

public final class JDBCDatabaseCommunicationEngine
extends DatabaseCommunicationEngine {
    private final ProxySQLExecutor proxySQLExecutor;
    private final Collection<Statement> cachedStatements = new CopyOnWriteArrayList<Statement>();
    private final Collection<ResultSet> cachedResultSets = new CopyOnWriteArrayList<ResultSet>();
    private final JDBCBackendConnection backendConnection;
    private volatile SQLFederationExecutor federationExecutor;

    public JDBCDatabaseCommunicationEngine(String driverType, ShardingSphereDatabase database, QueryContext queryContext, JDBCBackendConnection backendConnection) {
        super(driverType, database, queryContext, backendConnection);
        this.proxySQLExecutor = new ProxySQLExecutor(driverType, backendConnection, this);
        this.backendConnection = backendConnection;
    }

    public void add(Statement statement) {
        this.cachedStatements.add(statement);
    }

    public void add(ResultSet resultSet) {
        this.cachedResultSets.add(resultSet);
    }

    @Override
    public ResponseHeader execute() throws SQLException {
        QueryContext queryContext = this.getQueryContext();
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        ShardingSphereDatabase database = metaDataContexts.getMetaData().getDatabase(this.backendConnection.getConnectionSession().getDatabaseName());
        SQLFederationDeciderContext deciderContext = JDBCDatabaseCommunicationEngine.decide(queryContext, metaDataContexts.getMetaData().getProps(), database);
        if (deciderContext.isUseSQLFederation()) {
            this.prepareFederationExecutor();
            ResultSet resultSet = this.doExecuteFederation(queryContext, metaDataContexts);
            return this.processExecuteFederation(resultSet, metaDataContexts);
        }
        ExecutionContext executionContext = this.getKernelProcessor().generateExecutionContext(queryContext, this.getDatabase(), metaDataContexts.getMetaData().getGlobalRuleMetaData(), metaDataContexts.getMetaData().getProps(), this.backendConnection.getConnectionSession().getConnectionContext());
        if (executionContext.getExecutionUnits().isEmpty()) {
            return new UpdateResponseHeader(executionContext.getSqlStatementContext().getSqlStatement());
        }
        this.proxySQLExecutor.checkExecutePrerequisites(executionContext);
        List<ExecuteResult> result = this.proxySQLExecutor.execute(executionContext);
        this.refreshMetaData(executionContext);
        ExecuteResult executeResultSample = result.iterator().next();
        return executeResultSample instanceof QueryResult ? this.processExecuteQuery(executionContext, result, (QueryResult)executeResultSample) : this.processExecuteUpdate(executionContext, result);
    }

    private static SQLFederationDeciderContext decide(QueryContext queryContext, ConfigurationProperties props, ShardingSphereDatabase database) {
        SQLFederationDeciderEngine deciderEngine = new SQLFederationDeciderEngine(database.getRuleMetaData().getRules(), props);
        return deciderEngine.decide(queryContext, database);
    }

    private void prepareFederationExecutor() {
        MetaDataContexts metaDataContexts = ProxyContext.getInstance().getContextManager().getMetaDataContexts();
        String databaseName = this.backendConnection.getConnectionSession().getDatabaseName();
        DatabaseType databaseType = this.getQueryContext().getSqlStatementContext().getDatabaseType();
        String schemaName = this.getQueryContext().getSqlStatementContext().getTablesContext().getSchemaName().orElseGet(() -> DatabaseTypeEngine.getDefaultSchemaName((DatabaseType)databaseType, (String)databaseName));
        SQLFederationRule sqlFederationRule = (SQLFederationRule)metaDataContexts.getMetaData().getGlobalRuleMetaData().getSingleRule(SQLFederationRule.class);
        this.federationExecutor = sqlFederationRule.getSQLFederationExecutor(databaseName, schemaName, metaDataContexts.getMetaData(), metaDataContexts.getShardingSphereData(), new JDBCExecutor(BackendExecutorContext.getInstance().getExecutorEngine(), this.backendConnection.isSerialExecute()), ProxyContext.getInstance().getContextManager().getInstanceContext().getEventBusContext());
    }

    private ResultSet doExecuteFederation(QueryContext queryContext, MetaDataContexts metaDataContexts) throws SQLException {
        boolean isReturnGeneratedKeys = queryContext.getSqlStatementContext().getSqlStatement() instanceof MySQLInsertStatement;
        ShardingSphereDatabase database = metaDataContexts.getMetaData().getDatabase(this.backendConnection.getConnectionSession().getDatabaseName());
        DatabaseType protocolType = database.getProtocolType();
        DatabaseType databaseType = database.getResourceMetaData().getDatabaseType();
        ProxyJDBCExecutorCallback callback = ProxyJDBCExecutorCallbackFactory.newInstance(this.getDriverType(), protocolType, databaseType, queryContext.getSqlStatementContext().getSqlStatement(), this, isReturnGeneratedKeys, SQLExecutorExceptionHandler.isExceptionThrown(), true);
        DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine = this.createDriverExecutionPrepareEngine(isReturnGeneratedKeys, metaDataContexts);
        SQLFederationExecutorContext context = new SQLFederationExecutorContext(false, queryContext, metaDataContexts.getMetaData().getDatabases());
        return this.federationExecutor.executeQuery(prepareEngine, (JDBCExecutorCallback)callback, context);
    }

    private DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> createDriverExecutionPrepareEngine(boolean isReturnGeneratedKeys, MetaDataContexts metaData) {
        int maxConnectionsSizePerQuery = (Integer)metaData.getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        JDBCBackendStatement statementManager = (JDBCBackendStatement)this.backendConnection.getConnectionSession().getStatementManager();
        return new DriverExecutionPrepareEngine(this.getDriverType(), maxConnectionsSizePerQuery, (ExecutorConnectionManager)this.backendConnection, (ExecutorStatementManager)statementManager, (StorageResourceOption)new StatementOption(isReturnGeneratedKeys), metaData.getMetaData().getDatabase(this.backendConnection.getConnectionSession().getDatabaseName()).getRuleMetaData().getRules(), this.backendConnection.getConnectionSession().getDatabaseType());
    }

    private ResponseHeader processExecuteFederation(ResultSet resultSet, MetaDataContexts metaDataContexts) throws SQLException {
        int columnCount = resultSet.getMetaData().getColumnCount();
        this.setQueryHeaders(new ArrayList<QueryHeader>(columnCount));
        ShardingSphereDatabase database = metaDataContexts.getMetaData().getDatabase(this.backendConnection.getConnectionSession().getDatabaseName());
        QueryHeaderBuilderEngine queryHeaderBuilderEngine = new QueryHeaderBuilderEngine(null == database ? null : database.getProtocolType());
        for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
            this.getQueryHeaders().add(queryHeaderBuilderEngine.build((QueryResultMetaData)new JDBCQueryResultMetaData(resultSet.getMetaData()), database, columnIndex));
        }
        this.setMergedResult((MergedResult)new IteratorStreamMergedResult(Collections.singletonList(new JDBCStreamQueryResult(resultSet))));
        return new QueryResponseHeader(this.getQueryHeaders());
    }

    @Override
    public void close() throws SQLException {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        result.addAll(this.closeResultSets());
        result.addAll(this.closeStatements());
        this.closeFederationExecutor().ifPresent(result::add);
        if (result.isEmpty()) {
            return;
        }
        SQLException ex = new SQLException();
        result.forEach(ex::setNextException);
        throw ex;
    }

    private Collection<SQLException> closeResultSets() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (ResultSet each : this.cachedResultSets) {
            try {
                each.close();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        this.cachedResultSets.clear();
        return result;
    }

    private Collection<SQLException> closeStatements() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Statement each : this.cachedStatements) {
            try {
                each.cancel();
                each.close();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        this.cachedStatements.clear();
        return result;
    }

    private Optional<SQLException> closeFederationExecutor() {
        if (null != this.federationExecutor) {
            try {
                this.federationExecutor.close();
            }
            catch (SQLException ex) {
                return Optional.of(ex);
            }
        }
        return Optional.empty();
    }
}

