/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication;

import io.vertx.core.Future;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.dialect.exception.transaction.TableModifyInTransactionException;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.sane.SaneQueryResultEngineFactory;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.vertx.VertxExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.vertx.VertxExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorConnectionManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.ExecutorStatementManager;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.StorageResourceOption;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.vertx.VertxExecutionContext;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.proxy.backend.communication.vertx.VertxBackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.vertx.VertxBackendStatement;
import org.apache.shardingsphere.proxy.backend.communication.vertx.executor.ProxyReactiveExecutor;
import org.apache.shardingsphere.proxy.backend.context.BackendExecutorContext;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.session.transaction.TransactionStatus;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CloseStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DDLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.FetchStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.MoveStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.TruncateStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.OpenGaussStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.opengauss.ddl.OpenGaussCursorStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.PostgreSQLStatement;
import org.apache.shardingsphere.transaction.core.TransactionType;

public final class ReactiveProxySQLExecutor {
    private static final String TYPE = "Vert.x";
    private final VertxBackendConnection backendConnection;
    private final ProxyReactiveExecutor reactiveExecutor;

    public ReactiveProxySQLExecutor(VertxBackendConnection backendConnection) {
        this.backendConnection = backendConnection;
        this.reactiveExecutor = new ProxyReactiveExecutor(new VertxExecutor(BackendExecutorContext.getInstance().getExecutorEngine()));
    }

    public void checkExecutePrerequisites(ExecutionContext executionContext) {
        if (this.isExecuteDDLInXATransaction(executionContext.getSqlStatementContext().getSqlStatement()) || this.isExecuteDDLInPostgreSQLOpenGaussTransaction(executionContext.getSqlStatementContext().getSqlStatement())) {
            String tableName = executionContext.getSqlStatementContext() instanceof TableAvailable && !((TableAvailable)executionContext.getSqlStatementContext()).getAllTables().isEmpty() ? ((SimpleTableSegment)((TableAvailable)executionContext.getSqlStatementContext()).getAllTables().iterator().next()).getTableName().getIdentifier().getValue() : "unknown_table";
            throw new TableModifyInTransactionException(tableName);
        }
    }

    private boolean isExecuteDDLInXATransaction(SQLStatement sqlStatement) {
        TransactionStatus transactionStatus = this.backendConnection.getConnectionSession().getTransactionStatus();
        return TransactionType.XA == transactionStatus.getTransactionType() && transactionStatus.isInTransaction() && this.isUnsupportedDDLStatement(sqlStatement);
    }

    private boolean isExecuteDDLInPostgreSQLOpenGaussTransaction(SQLStatement sqlStatement) {
        boolean isPostgreSQLOpenGaussStatement = this.isPostgreSQLOrOpenGaussStatement(sqlStatement);
        boolean isSupportedStatement = this.isSupportedSQLStatement(sqlStatement);
        return sqlStatement instanceof DDLStatement && !isSupportedStatement && isPostgreSQLOpenGaussStatement && this.backendConnection.getConnectionSession().getTransactionStatus().isInTransaction();
    }

    private boolean isUnsupportedDDLStatement(SQLStatement sqlStatement) {
        if (this.isPostgreSQLOrOpenGaussStatement(sqlStatement) && this.isSupportedSQLStatement(sqlStatement)) {
            return false;
        }
        return sqlStatement instanceof DDLStatement;
    }

    private boolean isSupportedSQLStatement(SQLStatement sqlStatement) {
        return this.isCursorStatement(sqlStatement) || sqlStatement instanceof TruncateStatement;
    }

    private boolean isCursorStatement(SQLStatement sqlStatement) {
        return sqlStatement instanceof OpenGaussCursorStatement || sqlStatement instanceof CloseStatement || sqlStatement instanceof MoveStatement || sqlStatement instanceof FetchStatement;
    }

    private boolean isPostgreSQLOrOpenGaussStatement(SQLStatement sqlStatement) {
        return sqlStatement instanceof PostgreSQLStatement || sqlStatement instanceof OpenGaussStatement;
    }

    public Future<List<ExecuteResult>> execute(ExecutionContext executionContext) throws SQLException {
        String databaseName = this.backendConnection.getConnectionSession().getDatabaseName();
        Collection rules = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getDatabase(databaseName).getRuleMetaData().getRules();
        int maxConnectionsSizePerQuery = (Integer)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY);
        return this.useDriverToExecute(executionContext, rules, maxConnectionsSizePerQuery);
    }

    private Future<List<ExecuteResult>> useDriverToExecute(ExecutionContext executionContext, Collection<ShardingSphereRule> rules, int maxConnectionsSizePerQuery) throws SQLException {
        ExecutionGroupContext executionGroupContext;
        VertxBackendStatement statementManager = (VertxBackendStatement)this.backendConnection.getConnectionSession().getStatementManager();
        DriverExecutionPrepareEngine prepareEngine = new DriverExecutionPrepareEngine(TYPE, maxConnectionsSizePerQuery, (ExecutorConnectionManager)this.backendConnection, (ExecutorStatementManager)statementManager, (StorageResourceOption)new VertxExecutionContext(), rules, this.backendConnection.getConnectionSession().getDatabaseType());
        try {
            executionGroupContext = prepareEngine.prepare(executionContext.getRouteContext(), executionContext.getExecutionUnits());
        }
        catch (SQLException ex) {
            return Future.succeededFuture(this.getSaneExecuteResults(executionContext, ex));
        }
        executionGroupContext.setDatabaseName(this.backendConnection.getConnectionSession().getDatabaseName());
        executionGroupContext.setGrantee(this.backendConnection.getConnectionSession().getGrantee());
        executionGroupContext.setExecutionID(this.backendConnection.getConnectionSession().getExecutionId());
        return this.reactiveExecutor.execute(executionContext.getQueryContext(), (ExecutionGroupContext<VertxExecutionUnit>)executionGroupContext);
    }

    private List<ExecuteResult> getSaneExecuteResults(ExecutionContext executionContext, SQLException originalException) throws SQLException {
        DatabaseType databaseType = ProxyContext.getInstance().getDatabase(this.backendConnection.getConnectionSession().getDatabaseName()).getResourceMetaData().getDatabaseType();
        Optional executeResult = SaneQueryResultEngineFactory.getInstance((DatabaseType)databaseType).getSaneQueryResult(executionContext.getSqlStatementContext().getSqlStatement(), originalException);
        if (executeResult.isPresent()) {
            return Collections.singletonList(executeResult.get());
        }
        throw originalException;
    }
}

