/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication;

import lombok.Generated;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.proxy.backend.communication.BackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.DatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.JDBCDatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.communication.jdbc.connection.JDBCBackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.vertx.VertxBackendConnection;
import org.apache.shardingsphere.proxy.backend.communication.vertx.VertxDatabaseCommunicationEngine;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;

public final class DatabaseCommunicationEngineFactory {
    private static final DatabaseCommunicationEngineFactory INSTANCE = new DatabaseCommunicationEngineFactory();

    public static DatabaseCommunicationEngineFactory getInstance() {
        return INSTANCE;
    }

    public <T extends DatabaseCommunicationEngine> T newDatabaseCommunicationEngine(QueryContext queryContext, BackendConnection<?> backendConnection, boolean preferPreparedStatement) {
        DatabaseCommunicationEngine result;
        ShardingSphereDatabase database = ProxyContext.getInstance().getDatabase(backendConnection.getConnectionSession().getDatabaseName());
        if (backendConnection instanceof JDBCBackendConnection) {
            JDBCBackendConnection jdbcBackendConnection = (JDBCBackendConnection)backendConnection;
            String driverType = preferPreparedStatement || !queryContext.getParameters().isEmpty() ? "JDBC.PREPARED_STATEMENT" : "JDBC.STATEMENT";
            result = new JDBCDatabaseCommunicationEngine(driverType, database, queryContext, jdbcBackendConnection);
            jdbcBackendConnection.add(result);
        } else {
            VertxBackendConnection vertxBackendConnection = (VertxBackendConnection)backendConnection;
            result = new VertxDatabaseCommunicationEngine(database, queryContext, vertxBackendConnection);
        }
        return (T)result;
    }

    @Generated
    private DatabaseCommunicationEngineFactory() {
    }
}

