/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.communication;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.QueryContext;
import org.apache.shardingsphere.infra.binder.aware.CursorDefinitionAware;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.ddl.CloseStatementContext;
import org.apache.shardingsphere.infra.binder.statement.ddl.CursorStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.type.CursorAvailable;
import org.apache.shardingsphere.infra.context.kernel.KernelProcessor;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefreshEngine;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.distsql.exception.resource.EmptyResourceException;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.infra.merge.MergeEngine;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.util.SystemSchemaUtil;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.util.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.proxy.backend.communication.BackendConnection;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.RuleNotExistedException;
import org.apache.shardingsphere.proxy.backend.handler.data.DatabaseBackendHandler;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseCell;
import org.apache.shardingsphere.proxy.backend.response.data.QueryResponseRow;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeaderBuilderEngine;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.cursor.CursorNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CloseStatement;

public abstract class DatabaseCommunicationEngine
implements DatabaseBackendHandler {
    private final String driverType;
    private final ShardingSphereDatabase database;
    private final QueryContext queryContext;
    private final KernelProcessor kernelProcessor = new KernelProcessor();
    private final MetaDataRefreshEngine metadataRefreshEngine;
    private List<QueryHeader> queryHeaders;
    private MergedResult mergedResult;
    private final BackendConnection<?> backendConnection;

    public DatabaseCommunicationEngine(String driverType, ShardingSphereDatabase database, QueryContext queryContext, BackendConnection<?> backendConnection) {
        SQLStatementContext sqlStatementContext = queryContext.getSqlStatementContext();
        this.failedIfBackendNotReady(backendConnection.getConnectionSession(), sqlStatementContext);
        this.driverType = driverType;
        this.database = database;
        this.queryContext = queryContext;
        this.backendConnection = backendConnection;
        this.metadataRefreshEngine = new MetaDataRefreshEngine(database, ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps());
        if (sqlStatementContext instanceof CursorAvailable) {
            this.prepareCursorStatementContext((CursorAvailable)sqlStatementContext, backendConnection.getConnectionSession());
        }
    }

    private void failedIfBackendNotReady(ConnectionSession connectionSession, SQLStatementContext<?> sqlStatementContext) {
        ShardingSphereDatabase database = ProxyContext.getInstance().getDatabase(connectionSession.getDatabaseName());
        boolean isSystemSchema = SystemSchemaUtil.containsSystemSchema((DatabaseType)sqlStatementContext.getDatabaseType(), (Collection)sqlStatementContext.getTablesContext().getSchemaNames(), (ShardingSphereDatabase)database);
        ShardingSpherePreconditions.checkState((isSystemSchema || database.containsDataSource() ? 1 : 0) != 0, () -> new EmptyResourceException(connectionSession.getDatabaseName()));
        if (!isSystemSchema && !database.isComplete()) {
            throw new RuleNotExistedException();
        }
    }

    private void prepareCursorStatementContext(CursorAvailable statementContext, ConnectionSession connectionSession) {
        if (statementContext.getCursorName().isPresent()) {
            String cursorName = ((CursorNameSegment)statementContext.getCursorName().get()).getIdentifier().getValue().toLowerCase();
            this.prepareCursorStatementContext(statementContext, connectionSession, cursorName);
        }
        if (statementContext instanceof CloseStatementContext && ((CloseStatement)((CloseStatementContext)statementContext).getSqlStatement()).isCloseAll()) {
            connectionSession.getConnectionContext().clearCursorConnectionContext();
        }
    }

    private void prepareCursorStatementContext(CursorAvailable statementContext, ConnectionSession connectionSession, String cursorName) {
        if (statementContext instanceof CursorStatementContext) {
            connectionSession.getConnectionContext().getCursorConnectionContext().getCursorDefinitions().put(cursorName, (CursorStatementContext)statementContext);
        }
        if (statementContext instanceof CursorDefinitionAware) {
            CursorStatementContext cursorStatementContext = (CursorStatementContext)connectionSession.getConnectionContext().getCursorConnectionContext().getCursorDefinitions().get(cursorName);
            Preconditions.checkArgument((null != cursorStatementContext ? 1 : 0) != 0, (String)"Cursor %s does not exist.", (Object)cursorName);
            ((CursorDefinitionAware)statementContext).setUpCursorDefinition(cursorStatementContext);
        }
        if (statementContext instanceof CloseStatementContext) {
            connectionSession.getConnectionContext().getCursorConnectionContext().removeCursorName(cursorName);
        }
    }

    protected void refreshMetaData(ExecutionContext executionContext) throws SQLException {
        Optional event = this.metadataRefreshEngine.refresh(executionContext.getSqlStatementContext(), executionContext.getRouteContext().getRouteUnits());
        if (ProxyContext.getInstance().getContextManager().getInstanceContext().isCluster() && event.isPresent()) {
            ProxyContext.getInstance().getContextManager().getInstanceContext().getEventBusContext().post(event.get());
        }
    }

    protected QueryResponseHeader processExecuteQuery(ExecutionContext executionContext, List<QueryResult> queryResults, QueryResult queryResultSample) throws SQLException {
        this.queryHeaders = this.createQueryHeaders(executionContext, queryResultSample);
        this.mergedResult = this.mergeQuery(executionContext.getSqlStatementContext(), queryResults);
        return new QueryResponseHeader(this.queryHeaders);
    }

    protected List<QueryHeader> createQueryHeaders(ExecutionContext executionContext, QueryResult queryResultSample) throws SQLException {
        int columnCount = this.getColumnCount(executionContext, queryResultSample);
        ArrayList<QueryHeader> result = new ArrayList<QueryHeader>(columnCount);
        QueryHeaderBuilderEngine queryHeaderBuilderEngine = new QueryHeaderBuilderEngine(this.database.getProtocolType());
        for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
            result.add(this.createQueryHeader(queryHeaderBuilderEngine, executionContext, queryResultSample, this.database, columnIndex));
        }
        return result;
    }

    protected QueryHeader createQueryHeader(QueryHeaderBuilderEngine queryHeaderBuilderEngine, ExecutionContext executionContext, QueryResult queryResultSample, ShardingSphereDatabase database, int columnIndex) throws SQLException {
        return this.hasSelectExpandProjections(executionContext.getSqlStatementContext()) ? queryHeaderBuilderEngine.build(((SelectStatementContext)executionContext.getSqlStatementContext()).getProjectionsContext(), queryResultSample.getMetaData(), database, columnIndex) : queryHeaderBuilderEngine.build(queryResultSample.getMetaData(), database, columnIndex);
    }

    protected int getColumnCount(ExecutionContext executionContext, QueryResult queryResultSample) throws SQLException {
        return this.hasSelectExpandProjections(executionContext.getSqlStatementContext()) ? ((SelectStatementContext)executionContext.getSqlStatementContext()).getProjectionsContext().getExpandProjections().size() : queryResultSample.getMetaData().getColumnCount();
    }

    protected boolean hasSelectExpandProjections(SQLStatementContext<?> sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && !((SelectStatementContext)sqlStatementContext).getProjectionsContext().getExpandProjections().isEmpty();
    }

    protected MergedResult mergeQuery(SQLStatementContext<?> sqlStatementContext, List<QueryResult> queryResults) throws SQLException {
        MergeEngine mergeEngine = new MergeEngine(this.database, ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps(), this.getBackendConnection().getConnectionSession().getConnectionContext());
        return mergeEngine.merge(queryResults, sqlStatementContext);
    }

    protected UpdateResponseHeader processExecuteUpdate(ExecutionContext executionContext, Collection<UpdateResult> updateResults) {
        UpdateResponseHeader result = new UpdateResponseHeader(executionContext.getSqlStatementContext().getSqlStatement(), updateResults);
        this.mergeUpdateCount(executionContext.getSqlStatementContext(), result);
        return result;
    }

    protected void mergeUpdateCount(SQLStatementContext<?> sqlStatementContext, UpdateResponseHeader response) {
        if (this.isNeedAccumulate(sqlStatementContext)) {
            response.mergeUpdateCount();
        }
    }

    protected boolean isNeedAccumulate(SQLStatementContext<?> sqlStatementContext) {
        Optional<DataNodeContainedRule> dataNodeContainedRule = this.findDataNodeContainedRule();
        return dataNodeContainedRule.isPresent() && dataNodeContainedRule.get().isNeedAccumulate(sqlStatementContext.getTablesContext().getTableNames());
    }

    private Optional<DataNodeContainedRule> findDataNodeContainedRule() {
        for (ShardingSphereRule each : this.database.getRuleMetaData().getRules()) {
            if (!(each instanceof DataNodeContainedRule)) continue;
            return Optional.of((DataNodeContainedRule)each);
        }
        return Optional.empty();
    }

    @Override
    public boolean next() throws SQLException {
        return null != this.mergedResult && this.mergedResult.next();
    }

    @Override
    public QueryResponseRow getRowData() throws SQLException {
        ArrayList<QueryResponseCell> cells = new ArrayList<QueryResponseCell>(this.queryHeaders.size());
        for (int columnIndex = 1; columnIndex <= this.queryHeaders.size(); ++columnIndex) {
            Object data = this.mergedResult.getValue(columnIndex, Object.class);
            cells.add(new QueryResponseCell(this.queryHeaders.get(columnIndex - 1).getColumnType(), data));
        }
        return new QueryResponseRow(cells);
    }

    @Generated
    protected String getDriverType() {
        return this.driverType;
    }

    @Generated
    protected ShardingSphereDatabase getDatabase() {
        return this.database;
    }

    @Generated
    protected QueryContext getQueryContext() {
        return this.queryContext;
    }

    @Generated
    protected KernelProcessor getKernelProcessor() {
        return this.kernelProcessor;
    }

    @Generated
    protected MetaDataRefreshEngine getMetadataRefreshEngine() {
        return this.metadataRefreshEngine;
    }

    @Generated
    protected List<QueryHeader> getQueryHeaders() {
        return this.queryHeaders;
    }

    @Generated
    protected MergedResult getMergedResult() {
        return this.mergedResult;
    }

    @Generated
    protected BackendConnection<?> getBackendConnection() {
        return this.backendConnection;
    }

    @Generated
    protected void setQueryHeaders(List<QueryHeader> queryHeaders) {
        this.queryHeaders = queryHeaders;
    }

    @Generated
    protected void setMergedResult(MergedResult mergedResult) {
        this.mergedResult = mergedResult;
    }
}

