/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.transaction;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.data.impl.SchemaAssignedDatabaseBackendHandler;
import org.apache.shardingsphere.sharding.merge.ddl.fetch.FetchOrderByValueQueuesHolder;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.TCLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.XAStatement;
import org.apache.shardingsphere.transaction.TransactionHolder;

public final class TransactionXAHandler
implements TextProtocolBackendHandler {
    private final XAStatement tclStatement;
    private final ConnectionSession connectionSession;
    private final SchemaAssignedDatabaseBackendHandler backendHandler;

    public TransactionXAHandler(SQLStatementContext<? extends TCLStatement> sqlStatementContext, String sql, ConnectionSession connectionSession) {
        this.tclStatement = (XAStatement)sqlStatementContext.getSqlStatement();
        this.connectionSession = connectionSession;
        this.backendHandler = new SchemaAssignedDatabaseBackendHandler(sqlStatementContext, sql, connectionSession);
    }

    @Override
    public boolean next() throws SQLException {
        return this.tclStatement.getOp().equals("RECOVER") && this.backendHandler.next();
    }

    @Override
    public Collection<Object> getRowData() throws SQLException {
        return this.tclStatement.getOp().equals("RECOVER") ? this.backendHandler.getRowData() : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseHeader execute() throws SQLException {
        switch (this.tclStatement.getOp()) {
            case "START": 
            case "BEGIN": {
                if (this.connectionSession.getTransactionStatus().isInTransaction()) {
                    throw new SQLException("can not start in a Active transaction");
                }
                ResponseHeader header = this.backendHandler.execute();
                TransactionHolder.setInTransaction();
                this.connectionSession.getTransactionStatus().setManualXA(true);
                return header;
            }
            case "END": 
            case "PREPARE": 
            case "RECOVER": {
                return this.backendHandler.execute();
            }
            case "COMMIT": 
            case "ROLLBACK": {
                try {
                    ResponseHeader responseHeader = this.backendHandler.execute();
                    return responseHeader;
                }
                finally {
                    this.connectionSession.getTransactionStatus().setManualXA(false);
                    TransactionHolder.clear();
                    FetchOrderByValueQueuesHolder.remove();
                }
            }
        }
        throw new SQLException("unrecognized XA statement " + this.tclStatement.getOp());
    }

    @Generated
    public TransactionXAHandler(XAStatement tclStatement, ConnectionSession connectionSession, SchemaAssignedDatabaseBackendHandler backendHandler) {
        this.tclStatement = tclStatement;
        this.connectionSession = connectionSession;
        this.backendHandler = backendHandler;
    }
}

