/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.transaction;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.util.TransactionUtil;
import org.apache.shardingsphere.sql.parser.sql.common.constant.TransactionAccessType;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.SetTransactionStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.MySQLStatement;

public final class TransactionSetHandler
implements TextProtocolBackendHandler {
    private final SetTransactionStatement sqlStatement;
    private final ConnectionSession connectionSession;

    @Override
    public ResponseHeader execute() throws SQLException {
        if (null == this.sqlStatement.getScope() && this.connectionSession.getTransactionStatus().isInTransaction()) {
            throw new SQLException("when in transaction, not support set transaction");
        }
        if (TransactionAccessType.READ_ONLY == this.sqlStatement.getAccessMode()) {
            this.connectionSession.setReadOnly(true);
        } else if (TransactionAccessType.READ_WRITE == this.sqlStatement.getAccessMode()) {
            this.connectionSession.setReadOnly(false);
        }
        if (null != this.sqlStatement.getIsolationLevel()) {
            if (this.sqlStatement instanceof MySQLStatement) {
                this.connectionSession.setDefaultIsolationLevel(TransactionUtil.getTransactionIsolationLevel(4));
            } else {
                this.connectionSession.setDefaultIsolationLevel(TransactionUtil.getTransactionIsolationLevel(2));
            }
            this.connectionSession.setIsolationLevel(this.sqlStatement.getIsolationLevel());
        }
        return new UpdateResponseHeader((SQLStatement)this.sqlStatement);
    }

    @Generated
    public TransactionSetHandler(SetTransactionStatement sqlStatement, ConnectionSession connectionSession) {
        this.sqlStatement = sqlStatement;
        this.connectionSession = connectionSession;
    }
}

