/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.transaction;

import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.data.impl.BroadcastDatabaseBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.transaction.TransactionAutoCommitHandler;
import org.apache.shardingsphere.proxy.backend.text.transaction.TransactionBackendHandler;
import org.apache.shardingsphere.proxy.backend.text.transaction.TransactionSetHandler;
import org.apache.shardingsphere.proxy.backend.text.transaction.TransactionXAHandler;
import org.apache.shardingsphere.sql.parser.sql.common.constant.OperationScope;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.BeginTransactionStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.CommitStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.ReleaseSavepointStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.RollbackStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.SavepointStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.SetAutoCommitStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.SetTransactionStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.StartTransactionStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.TCLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.tcl.XAStatement;
import org.apache.shardingsphere.transaction.core.TransactionOperationType;

public final class TransactionBackendHandlerFactory {
    public static TextProtocolBackendHandler newInstance(SQLStatementContext<? extends TCLStatement> sqlStatementContext, String sql, ConnectionSession connectionSession) {
        TCLStatement tclStatement = (TCLStatement)sqlStatementContext.getSqlStatement();
        if (tclStatement instanceof BeginTransactionStatement || tclStatement instanceof StartTransactionStatement) {
            return new TransactionBackendHandler(tclStatement, TransactionOperationType.BEGIN, connectionSession);
        }
        if (tclStatement instanceof SetAutoCommitStatement) {
            return new TransactionAutoCommitHandler((SetAutoCommitStatement)tclStatement, connectionSession);
        }
        if (tclStatement instanceof SavepointStatement) {
            return new TransactionBackendHandler(tclStatement, TransactionOperationType.SAVEPOINT, connectionSession);
        }
        if (tclStatement instanceof ReleaseSavepointStatement) {
            return new TransactionBackendHandler(tclStatement, TransactionOperationType.RELEASE_SAVEPOINT, connectionSession);
        }
        if (tclStatement instanceof CommitStatement) {
            return new TransactionBackendHandler(tclStatement, TransactionOperationType.COMMIT, connectionSession);
        }
        if (tclStatement instanceof RollbackStatement) {
            return ((RollbackStatement)tclStatement).getSavepointName().isPresent() ? new TransactionBackendHandler(tclStatement, TransactionOperationType.ROLLBACK_TO_SAVEPOINT, connectionSession) : new TransactionBackendHandler(tclStatement, TransactionOperationType.ROLLBACK, connectionSession);
        }
        if (tclStatement instanceof SetTransactionStatement && OperationScope.GLOBAL != ((SetTransactionStatement)tclStatement).getScope()) {
            return new TransactionSetHandler((SetTransactionStatement)tclStatement, connectionSession);
        }
        if (tclStatement instanceof XAStatement) {
            return new TransactionXAHandler(sqlStatementContext, sql, connectionSession);
        }
        return new BroadcastDatabaseBackendHandler(sqlStatementContext, sql, connectionSession);
    }

    @Generated
    private TransactionBackendHandlerFactory() {
    }
}

