/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.rql.rule;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowSingleTableRulesStatement;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.singletable.config.SingleTableRuleConfiguration;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class SingleTableRulesQueryResultSet
implements DistSQLResultSet {
    private Iterator<String> data = Collections.emptyIterator();

    public void init(ShardingSphereDatabase database, SQLStatement sqlStatement) {
        Optional<SingleTableRuleConfiguration> ruleConfig = database.getRuleMetaData().getConfigurations().stream().filter(each -> each instanceof SingleTableRuleConfiguration).map(each -> (SingleTableRuleConfiguration)each).findAny();
        ruleConfig.flatMap(SingleTableRuleConfiguration::getDefaultDataSource).ifPresent(optional -> {
            this.data = Collections.singletonList(optional).iterator();
        });
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("name", "resource_name");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return Arrays.asList("default", this.data.next());
    }

    public String getType() {
        return ShowSingleTableRulesStatement.class.getName();
    }
}

