/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.rql.rule;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowSingleTableStatement;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.singletable.rule.SingleTableRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class SingleTableQueryResultSet
implements DistSQLResultSet {
    private Iterator<DataNode> data = Collections.emptyIterator();

    public void init(ShardingSphereDatabase database, SQLStatement sqlStatement) {
        ShowSingleTableStatement showSingleTableStatement = (ShowSingleTableStatement)sqlStatement;
        Stream<DataNode> singleTableRules = database.getRuleMetaData().getRules().stream().filter(each -> each instanceof SingleTableRule).map(each -> (SingleTableRule)each).map(each -> each.getSingleTableDataNodes().values()).flatMap(Collection::stream).filter(Objects::nonNull).map(each -> (DataNode)each.iterator().next());
        if (null != showSingleTableStatement.getTableName()) {
            singleTableRules = singleTableRules.filter(each -> showSingleTableStatement.getTableName().equals(each.getTableName()));
        }
        this.data = singleTableRules.collect(Collectors.toList()).iterator();
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("table_name", "resource_name");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        DataNode next = this.data.next();
        return Arrays.asList(next.getTableName(), next.getDataSourceName());
    }

    public String getType() {
        return ShowSingleTableStatement.class.getName();
    }
}

