/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.rql.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowRulesUsedResourceStatement;
import org.apache.shardingsphere.encrypt.api.config.EncryptRuleConfiguration;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.readwritesplitting.api.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.api.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class RulesUsedResourceQueryResultSet
implements DistSQLResultSet {
    private static final String TYPE = ShowRulesUsedResourceStatement.class.getName();
    private static final String SHARDING = "sharding";
    private static final String READWRITE_SPLITTING = "readwrite_splitting";
    private static final String DB_DISCOVERY = "db_discovery";
    private static final String ENCRYPT = "encrypt";
    private static final String SHADOW = "shadow";
    private static final Map<String, Class<? extends RuleConfiguration>> FEATURE_MAP = new HashMap<String, Class<? extends RuleConfiguration>>(5, 1.0f);
    private Iterator<Collection<Object>> data;

    public void init(ShardingSphereDatabase database, SQLStatement sqlStatement) {
        ArrayList<Collection<Object>> data = new ArrayList<Collection<Object>>();
        ShowRulesUsedResourceStatement statement = (ShowRulesUsedResourceStatement)sqlStatement;
        String resourceName = statement.getResourceName().orElse(null);
        if (this.hasRulesConfiguration(database) && database.getResource().getDataSources().containsKey(resourceName)) {
            this.getRulesConfig(database.getRuleMetaData().getConfigurations(), resourceName, data);
        }
        this.data = data.iterator();
    }

    private void getRulesConfig(Collection<RuleConfiguration> ruleConfigs, String resourceName, List<Collection<Object>> data) {
        ruleConfigs.forEach(each -> {
            this.getRulesConfigForSharding((RuleConfiguration)each, data);
            this.getRulesConfigForReadwriteSplitting((RuleConfiguration)each, resourceName, data);
            this.getRulesConfigForDBDiscovery((RuleConfiguration)each, resourceName, data);
            this.getRulesConfigForEncrypt((RuleConfiguration)each, data);
            this.getRulesConfigForShadow((RuleConfiguration)each, resourceName, data);
        });
    }

    private void getRulesConfigForSharding(RuleConfiguration ruleConfig, List<Collection<Object>> result) {
        if (!this.matchFeature(ruleConfig, SHARDING)) {
            return;
        }
        ShardingRuleConfiguration config = (ShardingRuleConfiguration)ruleConfig;
        config.getAutoTables().forEach(each -> result.add(this.buildRow(SHARDING, each.getLogicTable())));
        config.getTables().forEach(each -> result.add(this.buildRow(SHARDING, each.getLogicTable())));
    }

    private void getRulesConfigForReadwriteSplitting(RuleConfiguration ruleConfig, String resourceName, List<Collection<Object>> result) {
        if (!this.matchFeature(ruleConfig, READWRITE_SPLITTING)) {
            return;
        }
        ReadwriteSplittingRuleConfiguration config = (ReadwriteSplittingRuleConfiguration)ruleConfig;
        config.getDataSources().forEach(each -> {
            if (each.getWriteDataSourceName().isPresent() && ((String)each.getWriteDataSourceName().get()).equalsIgnoreCase(resourceName)) {
                result.add(this.buildRow(READWRITE_SPLITTING, each.getName()));
            }
            if (each.getReadDataSourceNames().isPresent() && Arrays.asList(((String)each.getReadDataSourceNames().get()).split(",")).contains(resourceName)) {
                result.add(this.buildRow(READWRITE_SPLITTING, each.getName()));
            }
        });
    }

    private void getRulesConfigForDBDiscovery(RuleConfiguration ruleConfig, String resourceName, List<Collection<Object>> result) {
        if (!this.matchFeature(ruleConfig, DB_DISCOVERY)) {
            return;
        }
        DatabaseDiscoveryRuleConfiguration config = (DatabaseDiscoveryRuleConfiguration)ruleConfig;
        config.getDataSources().forEach(each -> {
            if (each.getDataSourceNames().contains(resourceName)) {
                result.add(this.buildRow(DB_DISCOVERY, each.getGroupName()));
            }
        });
    }

    private void getRulesConfigForEncrypt(RuleConfiguration ruleConfig, List<Collection<Object>> result) {
        if (!this.matchFeature(ruleConfig, ENCRYPT)) {
            return;
        }
        EncryptRuleConfiguration config = (EncryptRuleConfiguration)ruleConfig;
        config.getTables().forEach(each -> result.add(this.buildRow(ENCRYPT, each.getName())));
    }

    private void getRulesConfigForShadow(RuleConfiguration ruleConfig, String resourceName, List<Collection<Object>> result) {
        if (!this.matchFeature(ruleConfig, SHADOW)) {
            return;
        }
        ShadowRuleConfiguration config = (ShadowRuleConfiguration)ruleConfig;
        for (Map.Entry each : config.getDataSources().entrySet()) {
            if (!((ShadowDataSourceConfiguration)each.getValue()).getShadowDataSourceName().equalsIgnoreCase(resourceName) && !((ShadowDataSourceConfiguration)each.getValue()).getSourceDataSourceName().equalsIgnoreCase(resourceName)) continue;
            result.add(this.buildRow(SHADOW, (String)each.getKey()));
        }
    }

    private boolean matchFeature(RuleConfiguration ruleConfig, String feature) {
        return null != ruleConfig && ruleConfig.getClass().getName().equals(FEATURE_MAP.get(feature).getName());
    }

    private Collection<Object> buildRow(String type, String name) {
        return Arrays.asList(type, name);
    }

    private boolean hasRulesConfiguration(ShardingSphereDatabase database) {
        Collection configs = database.getRuleMetaData().getConfigurations();
        return null != configs && !configs.isEmpty();
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("type", "name");
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.data.next();
    }

    public String getType() {
        return TYPE;
    }

    static {
        FEATURE_MAP.put(SHARDING, ShardingRuleConfiguration.class);
        FEATURE_MAP.put(READWRITE_SPLITTING, ReadwriteSplittingRuleConfiguration.class);
        FEATURE_MAP.put(DB_DISCOVERY, DatabaseDiscoveryRuleConfiguration.class);
        FEATURE_MAP.put(ENCRYPT, EncryptRuleConfiguration.class);
        FEATURE_MAP.put(SHADOW, ShadowRuleConfiguration.class);
    }
}

