/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.rql.resource;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.distsql.parser.statement.rql.show.ShowUnusedResourcesStatement;
import org.apache.shardingsphere.infra.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.datasource.props.DataSourcePropertiesCreator;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.ShardingSphereResource;
import org.apache.shardingsphere.infra.metadata.database.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class UnusedDataSourceQueryResultSet
implements DistSQLResultSet {
    private static final String CONNECTION_TIMEOUT_MILLISECONDS = "connectionTimeoutMilliseconds";
    private static final String IDLE_TIMEOUT_MILLISECONDS = "idleTimeoutMilliseconds";
    private static final String MAX_LIFETIME_MILLISECONDS = "maxLifetimeMilliseconds";
    private static final String MAX_POOL_SIZE = "maxPoolSize";
    private static final String MIN_POOL_SIZE = "minPoolSize";
    private static final String READ_ONLY = "readOnly";
    private ShardingSphereResource resource;
    private Map<String, DataSourceProperties> dataSourcePropsMap;
    private Iterator<String> dataSourceNames;

    public void init(ShardingSphereDatabase database, SQLStatement sqlStatement) {
        this.resource = database.getResource();
        this.dataSourcePropsMap = new LinkedHashMap<String, DataSourceProperties>(database.getResource().getDataSources().size(), 1.0f);
        Multimap<String, String> inUsedMultiMap = this.getInUsedResources(database.getRuleMetaData());
        for (Map.Entry entry : database.getResource().getDataSources().entrySet()) {
            if (inUsedMultiMap.containsKey(entry.getKey())) continue;
            this.dataSourcePropsMap.put((String)entry.getKey(), DataSourcePropertiesCreator.create((DataSource)((DataSource)entry.getValue())));
        }
        this.dataSourceNames = this.dataSourcePropsMap.keySet().iterator();
    }

    private Multimap<String, String> getInUsedResources(ShardingSphereRuleMetaData ruleMetaData) {
        LinkedListMultimap result = LinkedListMultimap.create();
        for (ShardingSphereRule each : ruleMetaData.getRules()) {
            Set<String> inUsedResourceNames;
            if (each instanceof DataSourceContainedRule) {
                inUsedResourceNames = this.getInUsedResourceNames((DataSourceContainedRule)each);
                inUsedResourceNames.forEach(arg_0 -> UnusedDataSourceQueryResultSet.lambda$getInUsedResources$0((Multimap)result, each, arg_0));
            }
            if (!(each instanceof DataNodeContainedRule)) continue;
            inUsedResourceNames = this.getInUsedResourceNames((DataNodeContainedRule)each);
            inUsedResourceNames.forEach(arg_0 -> UnusedDataSourceQueryResultSet.lambda$getInUsedResources$1((Multimap)result, each, arg_0));
        }
        return result;
    }

    private Set<String> getInUsedResourceNames(DataSourceContainedRule rule) {
        HashSet<String> result = new HashSet<String>();
        for (Collection each : rule.getDataSourceMapper().values()) {
            result.addAll(each);
        }
        return result;
    }

    private Set<String> getInUsedResourceNames(DataNodeContainedRule rule) {
        HashSet<String> result = new HashSet<String>();
        for (Collection each : rule.getAllDataNodes().values()) {
            result.addAll(each.stream().map(DataNode::getDataSourceName).collect(Collectors.toList()));
        }
        return result;
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList("name", "type", "host", "port", "db", "connection_timeout_milliseconds", "idle_timeout_milliseconds", "max_lifetime_milliseconds", "max_pool_size", "min_pool_size", "read_only", "other_attributes");
    }

    public boolean next() {
        return this.dataSourceNames.hasNext();
    }

    public Collection<Object> getRowData() {
        String dataSourceName = this.dataSourceNames.next();
        DataSourceMetaData metaData = this.resource.getDataSourceMetaData(dataSourceName);
        LinkedList<Object> result = new LinkedList<Object>();
        result.add(dataSourceName);
        result.add(this.resource.getDatabaseType().getType());
        result.add(metaData.getHostname());
        result.add(metaData.getPort());
        result.add(metaData.getCatalog());
        DataSourceProperties dataSourceProps = this.dataSourcePropsMap.get(dataSourceName);
        Map standardProps = dataSourceProps.getPoolPropertySynonyms().getStandardProperties();
        result.add(this.getStandardProperty(standardProps, CONNECTION_TIMEOUT_MILLISECONDS));
        result.add(this.getStandardProperty(standardProps, IDLE_TIMEOUT_MILLISECONDS));
        result.add(this.getStandardProperty(standardProps, MAX_LIFETIME_MILLISECONDS));
        result.add(this.getStandardProperty(standardProps, MAX_POOL_SIZE));
        result.add(this.getStandardProperty(standardProps, MIN_POOL_SIZE));
        result.add(this.getStandardProperty(standardProps, READ_ONLY));
        Map otherProps = dataSourceProps.getCustomDataSourceProperties().getProperties();
        result.add(otherProps.isEmpty() ? "" : new Gson().toJson((Object)otherProps));
        return result;
    }

    private String getStandardProperty(Map<String, Object> standardProps, String key) {
        if (standardProps.containsKey(key) && null != standardProps.get(key)) {
            return standardProps.get(key).toString();
        }
        return "";
    }

    public String getType() {
        return ShowUnusedResourcesStatement.class.getName();
    }

    private static /* synthetic */ void lambda$getInUsedResources$1(Multimap result, ShardingSphereRule each, String eachResource) {
        result.put((Object)eachResource, (Object)each.getType());
    }

    private static /* synthetic */ void lambda$getInUsedResources$0(Multimap result, ShardingSphereRule each, String eachResource) {
        result.put((Object)eachResource, (Object)each.getType());
    }
}

