/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.rdl.rule;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobWorker;
import org.apache.shardingsphere.distsql.parser.statement.rdl.RuleDefinitionStatement;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.preprocess.RuleDefinitionAlterPreprocessor;
import org.apache.shardingsphere.infra.distsql.preprocess.RuleDefinitionAlterPreprocessorFactory;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionAlterUpdater;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionDropUpdater;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionUpdater;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionUpdaterFactory;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.version.MetadataVersionPreparedEvent;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.DatabaseRequiredBackendHandler;
import org.apache.shardingsphere.sharding.distsql.parser.statement.AlterDefaultShardingStrategyStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.AlterShardingAlgorithmStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.AlterShardingBindingTableRulesStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.AlterShardingBroadcastTableRulesStatement;
import org.apache.shardingsphere.sharding.distsql.parser.statement.AlterShardingTableRuleStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuleDefinitionBackendHandler<T extends RuleDefinitionStatement>
extends DatabaseRequiredBackendHandler<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleDefinitionBackendHandler.class);
    private static final Set<String> RULE_ALTERED_ACTIONS = new HashSet<String>(Arrays.asList(AlterShardingTableRuleStatement.class.getName(), AlterShardingAlgorithmStatement.class.getName(), AlterDefaultShardingStrategyStatement.class.getName(), AlterShardingBindingTableRulesStatement.class.getName(), AlterShardingBroadcastTableRulesStatement.class.getName()));

    public RuleDefinitionBackendHandler(T sqlStatement, ConnectionSession connectionSession) {
        super(sqlStatement, connectionSession);
    }

    @Override
    protected ResponseHeader execute(String databaseName, T sqlStatement) throws DistSQLException {
        RuleDefinitionUpdater ruleDefinitionUpdater = RuleDefinitionUpdaterFactory.getInstance(sqlStatement);
        Class ruleConfigClass = ruleDefinitionUpdater.getRuleConfigurationClass();
        ShardingSphereDatabase database = ProxyContext.getInstance().getDatabase(databaseName);
        RuleConfiguration currentRuleConfig = this.findCurrentRuleConfiguration(database, ruleConfigClass).orElse(null);
        ruleDefinitionUpdater.checkSQLStatement(database, sqlStatement, currentRuleConfig);
        Optional preprocessor = RuleDefinitionAlterPreprocessorFactory.findInstance(sqlStatement);
        if (!RuleAlteredJobWorker.isOnRuleAlteredActionEnabled((RuleConfiguration)currentRuleConfig)) {
            if (RULE_ALTERED_ACTIONS.contains(sqlStatement.getClass().getCanonicalName())) {
                log.warn("rule altered and scaling is not enabled.");
            }
        } else if (preprocessor.isPresent()) {
            this.prepareScaling(database, sqlStatement, (RuleDefinitionAlterUpdater)ruleDefinitionUpdater, currentRuleConfig, (RuleDefinitionAlterPreprocessor)preprocessor.get());
            return new UpdateResponseHeader((SQLStatement)sqlStatement);
        }
        if (this.getRefreshStatus((SQLStatement)sqlStatement, currentRuleConfig, ruleDefinitionUpdater)) {
            this.processSQLStatement(database, sqlStatement, ruleDefinitionUpdater, currentRuleConfig);
            this.persistRuleConfigurationChange(database);
        }
        return new UpdateResponseHeader((SQLStatement)sqlStatement);
    }

    private Optional<RuleConfiguration> findCurrentRuleConfiguration(ShardingSphereDatabase database, Class<? extends RuleConfiguration> ruleConfigClass) {
        for (RuleConfiguration each : database.getRuleMetaData().getConfigurations()) {
            if (!ruleConfigClass.isAssignableFrom(each.getClass())) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    private void processSQLStatement(ShardingSphereDatabase database, T sqlStatement, RuleDefinitionUpdater updater, RuleConfiguration currentRuleConfig) {
        if (updater instanceof RuleDefinitionCreateUpdater) {
            this.processCreate(database, sqlStatement, (RuleDefinitionCreateUpdater)updater, currentRuleConfig);
        } else if (updater instanceof RuleDefinitionAlterUpdater) {
            this.processAlter(sqlStatement, (RuleDefinitionAlterUpdater)updater, currentRuleConfig);
        } else if (updater instanceof RuleDefinitionDropUpdater) {
            this.processDrop(database, sqlStatement, (RuleDefinitionDropUpdater)updater, currentRuleConfig);
        } else {
            throw new UnsupportedOperationException(String.format("Cannot support RDL updater type `%s`", updater.getClass().getCanonicalName()));
        }
        ProxyContext.getInstance().getContextManager().alterRuleConfiguration(database.getName(), database.getRuleMetaData().getConfigurations());
    }

    private void processCreate(ShardingSphereDatabase database, T sqlStatement, RuleDefinitionCreateUpdater updater, RuleConfiguration currentRuleConfig) {
        RuleConfiguration toBeCreatedRuleConfig = updater.buildToBeCreatedRuleConfiguration(sqlStatement);
        if (null == currentRuleConfig) {
            database.getRuleMetaData().getConfigurations().add(toBeCreatedRuleConfig);
        } else {
            updater.updateCurrentRuleConfiguration(currentRuleConfig, toBeCreatedRuleConfig);
        }
    }

    private void processAlter(T sqlStatement, RuleDefinitionAlterUpdater updater, RuleConfiguration currentRuleConfig) {
        RuleConfiguration toBeAlteredRuleConfig = updater.buildToBeAlteredRuleConfiguration(sqlStatement);
        updater.updateCurrentRuleConfiguration(currentRuleConfig, toBeAlteredRuleConfig);
    }

    private void processDrop(ShardingSphereDatabase database, T sqlStatement, RuleDefinitionDropUpdater updater, RuleConfiguration currentRuleConfig) {
        if (!updater.hasAnyOneToBeDropped(sqlStatement, currentRuleConfig)) {
            return;
        }
        if (updater.updateCurrentRuleConfiguration(sqlStatement, currentRuleConfig)) {
            database.getRuleMetaData().getConfigurations().remove(currentRuleConfig);
        }
    }

    private void prepareScaling(ShardingSphereDatabase database, T sqlStatement, RuleDefinitionAlterUpdater updater, RuleConfiguration currentRuleConfig, RuleDefinitionAlterPreprocessor<?> preprocessor) {
        Optional metaDataPersistService = ProxyContext.getInstance().getContextManager().getMetaDataContexts().getPersistService();
        if (metaDataPersistService.isPresent()) {
            Optional newVersion = ((MetaDataPersistService)metaDataPersistService.get()).getDatabaseVersionPersistService().createNewVersion(database.getName());
            if (!newVersion.isPresent()) {
                throw new RuntimeException(String.format("Unable to get a new version for database: %s", database.getName()));
            }
            this.persistRuleConfigurationChange((MetaDataPersistService)metaDataPersistService.get(), (String)newVersion.get(), database, currentRuleConfig, this.getAlteredRuleConfig(sqlStatement, updater, currentRuleConfig, preprocessor));
        }
    }

    private void persistRuleConfigurationChange(MetaDataPersistService metaDataPersistService, String version, ShardingSphereDatabase database, RuleConfiguration currentRuleConfig, RuleConfiguration alteredRuleConfig) {
        Collection configurations = database.getRuleMetaData().getConfigurations();
        configurations.remove(currentRuleConfig);
        configurations.add(alteredRuleConfig);
        metaDataPersistService.getDatabaseRulePersistService().persist(database.getName(), version, configurations);
        ShardingSphereEventBus.getInstance().post((Object)new MetadataVersionPreparedEvent(version, database.getName()));
    }

    private void persistRuleConfigurationChange(ShardingSphereDatabase database) {
        ProxyContext.getInstance().getContextManager().getMetaDataContexts().getPersistService().ifPresent(optional -> optional.getDatabaseRulePersistService().persist(database.getName(), database.getRuleMetaData().getConfigurations()));
    }

    private RuleConfiguration getAlteredRuleConfig(T sqlStatement, RuleDefinitionAlterUpdater updater, RuleConfiguration currentRuleConfig, RuleDefinitionAlterPreprocessor preprocessor) {
        RuleConfiguration toBeAlteredRuleConfig = updater.buildToBeAlteredRuleConfiguration(sqlStatement);
        RuleConfiguration result = preprocessor.preprocess(currentRuleConfig, toBeAlteredRuleConfig);
        updater.updateCurrentRuleConfiguration(result, toBeAlteredRuleConfig);
        return result;
    }

    private boolean getRefreshStatus(SQLStatement sqlStatement, RuleConfiguration currentRuleConfig, RuleDefinitionUpdater updater) {
        if (updater instanceof RuleDefinitionDropUpdater) {
            return ((RuleDefinitionDropUpdater)updater).hasAnyOneToBeDropped(sqlStatement, currentRuleConfig);
        }
        return true;
    }
}

