/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.rdl.rule;

import java.util.Collections;
import java.util.Set;
import org.apache.shardingsphere.distsql.parser.statement.rdl.create.CreateDefaultSingleTableRuleStatement;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.resource.RequiredResourceMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.singletable.config.SingleTableRuleConfiguration;

public final class CreateDefaultSingleTableRuleStatementUpdater
implements RuleDefinitionCreateUpdater<CreateDefaultSingleTableRuleStatement, SingleTableRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, CreateDefaultSingleTableRuleStatement sqlStatement, SingleTableRuleConfiguration currentRuleConfig) throws DistSQLException {
        this.checkResourceExist(database, sqlStatement);
        this.checkDefaultResourceDuplicate(database.getName(), currentRuleConfig);
    }

    private void checkResourceExist(ShardingSphereDatabase database, CreateDefaultSingleTableRuleStatement sqlStatement) throws DistSQLException {
        Set resourceNames = database.getResource().getDataSources().keySet();
        DistSQLException.predictionThrow((boolean)resourceNames.contains(sqlStatement.getDefaultResource()), () -> new RequiredResourceMissedException(database.getName(), Collections.singleton(sqlStatement.getDefaultResource())));
    }

    private void checkDefaultResourceDuplicate(String databaseName, SingleTableRuleConfiguration currentRuleConfig) throws DistSQLException {
        if (null != currentRuleConfig) {
            DistSQLException.predictionThrow((!currentRuleConfig.getDefaultDataSource().isPresent() ? 1 : 0) != 0, () -> new DuplicateRuleException("default single table rule", databaseName));
        }
    }

    public SingleTableRuleConfiguration buildToBeCreatedRuleConfiguration(CreateDefaultSingleTableRuleStatement sqlStatement) {
        SingleTableRuleConfiguration result = new SingleTableRuleConfiguration();
        result.setDefaultDataSource(sqlStatement.getDefaultResource());
        return result;
    }

    public void updateCurrentRuleConfiguration(SingleTableRuleConfiguration currentRuleConfig, SingleTableRuleConfiguration toBeCreatedRuleConfig) {
        currentRuleConfig.setDefaultDataSource((String)toBeCreatedRuleConfig.getDefaultDataSource().get());
    }

    public Class<SingleTableRuleConfiguration> getRuleConfigurationClass() {
        return SingleTableRuleConfiguration.class;
    }

    public String getType() {
        return CreateDefaultSingleTableRuleStatement.class.getName();
    }
}

