/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.rdl.rule;

import java.util.Collections;
import java.util.Set;
import org.apache.shardingsphere.distsql.parser.statement.rdl.alter.AlterDefaultSingleTableRuleStatement;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.resource.RequiredResourceMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionAlterUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.singletable.config.SingleTableRuleConfiguration;

public final class AlterDefaultSingleTableRuleStatementUpdater
implements RuleDefinitionAlterUpdater<AlterDefaultSingleTableRuleStatement, SingleTableRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereDatabase database, AlterDefaultSingleTableRuleStatement sqlStatement, SingleTableRuleConfiguration currentRuleConfig) throws DistSQLException {
        String databaseName = database.getName();
        this.checkConfigurationExist(databaseName, currentRuleConfig);
        this.checkResourceExist(database, sqlStatement);
        this.checkDefaultResourceExist(databaseName, currentRuleConfig);
    }

    private void checkConfigurationExist(String databaseName, SingleTableRuleConfiguration currentRuleConfig) throws DistSQLException {
        DistSQLException.predictionThrow((null != currentRuleConfig ? 1 : 0) != 0, () -> new RequiredRuleMissedException(databaseName, "single table"));
    }

    private void checkResourceExist(ShardingSphereDatabase database, AlterDefaultSingleTableRuleStatement sqlStatement) throws DistSQLException {
        Set resourceNames = database.getResource().getDataSources().keySet();
        DistSQLException.predictionThrow((boolean)resourceNames.contains(sqlStatement.getDefaultResource()), () -> new RequiredResourceMissedException(database.getName(), Collections.singleton(sqlStatement.getDefaultResource())));
    }

    private void checkDefaultResourceExist(String databaseName, SingleTableRuleConfiguration currentRuleConfig) throws DistSQLException {
        DistSQLException.predictionThrow((boolean)currentRuleConfig.getDefaultDataSource().isPresent(), () -> new RequiredRuleMissedException("single table", databaseName));
    }

    public SingleTableRuleConfiguration buildToBeAlteredRuleConfiguration(AlterDefaultSingleTableRuleStatement sqlStatement) {
        SingleTableRuleConfiguration result = new SingleTableRuleConfiguration();
        result.setDefaultDataSource(sqlStatement.getDefaultResource());
        return result;
    }

    public void updateCurrentRuleConfiguration(SingleTableRuleConfiguration currentRuleConfig, SingleTableRuleConfiguration toBeCreatedRuleConfig) {
        currentRuleConfig.setDefaultDataSource((String)toBeCreatedRuleConfig.getDefaultDataSource().get());
    }

    public Class<SingleTableRuleConfiguration> getRuleConfigurationClass() {
        return SingleTableRuleConfiguration.class;
    }

    public String getType() {
        return AlterDefaultSingleTableRuleStatement.class.getName();
    }
}

