/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.rdl.resource;

import com.zaxxer.hikari.HikariDataSource;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.distsql.parser.segment.DataSourceSegment;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;

public final class ResourceSegmentsConverter {
    public static Map<String, DataSourceProperties> convert(DatabaseType databaseType, Collection<DataSourceSegment> resources) {
        LinkedHashMap<String, DataSourceProperties> result = new LinkedHashMap<String, DataSourceProperties>(resources.size(), 1.0f);
        for (DataSourceSegment each : resources) {
            result.put(each.getName(), new DataSourceProperties(HikariDataSource.class.getName(), ResourceSegmentsConverter.createProperties(databaseType, each)));
        }
        return result;
    }

    private static Map<String, Object> createProperties(DatabaseType databaseType, DataSourceSegment segment) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("jdbcUrl", ResourceSegmentsConverter.getURL(databaseType, segment));
        result.put("username", segment.getUser());
        result.put("password", segment.getPassword());
        if (null != segment.getProperties()) {
            result.putAll(segment.getProperties());
        }
        return result;
    }

    private static String getURL(DatabaseType databaseType, DataSourceSegment segment) {
        if (null != segment.getUrl()) {
            return segment.getUrl();
        }
        return String.format("%s//%s:%s/%s", databaseType.getJdbcUrlPrefixes().iterator().next(), segment.getHostname(), segment.getPort(), segment.getDatabase());
    }

    @Generated
    private ResourceSegmentsConverter() {
    }
}

