/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.text.distsql.rdl.resource;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.parser.statement.rdl.drop.DropResourceStatement;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.resource.RequiredResourceMissedException;
import org.apache.shardingsphere.infra.distsql.exception.resource.ResourceInUsedException;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataSourceContainedRule;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.response.header.ResponseHeader;
import org.apache.shardingsphere.proxy.backend.response.header.update.UpdateResponseHeader;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.text.DatabaseRequiredBackendHandler;
import org.apache.shardingsphere.singletable.rule.SingleTableRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class DropResourceBackendHandler
extends DatabaseRequiredBackendHandler<DropResourceStatement> {
    public DropResourceBackendHandler(DropResourceStatement sqlStatement, ConnectionSession connectionSession) {
        super(sqlStatement, connectionSession);
    }

    @Override
    public ResponseHeader execute(String databaseName, DropResourceStatement sqlStatement) throws DistSQLException {
        Collection toBeDroppedResourceNames = sqlStatement.getNames();
        this.check(databaseName, toBeDroppedResourceNames, sqlStatement.isIgnoreSingleTables(), sqlStatement.isContainsExistClause());
        ProxyContext.getInstance().getContextManager().dropResource(databaseName, toBeDroppedResourceNames);
        return new UpdateResponseHeader((SQLStatement)sqlStatement);
    }

    private void check(String databaseName, Collection<String> toBeDroppedResourceNames, boolean ignoreSingleTables, boolean allowNotExist) throws DistSQLException {
        if (!allowNotExist) {
            this.checkResourceNameExisted(databaseName, toBeDroppedResourceNames);
        }
        this.checkResourceNameNotInUse(databaseName, toBeDroppedResourceNames, ignoreSingleTables);
    }

    private void checkResourceNameExisted(String databaseName, Collection<String> resourceNames) throws DistSQLException {
        Map resources = ProxyContext.getInstance().getDatabase(databaseName).getResource().getDataSources();
        Collection notExistedResourceNames = resourceNames.stream().filter(each -> !resources.containsKey(each)).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)notExistedResourceNames.isEmpty(), () -> new RequiredResourceMissedException(databaseName, notExistedResourceNames));
    }

    private void checkResourceNameNotInUse(String databaseName, Collection<String> toBeDroppedResourceNames, boolean ignoreSingleTables) throws DistSQLException {
        Multimap<String, String> inUsedMultimap = this.getInUsedResources(databaseName);
        Set inUsedResourceNames = inUsedMultimap.keySet();
        inUsedResourceNames.retainAll(toBeDroppedResourceNames);
        if (!inUsedResourceNames.isEmpty()) {
            if (ignoreSingleTables) {
                this.checkResourceNameNotInUseIgnoreSingleTableRule(new HashSet<String>(inUsedResourceNames), inUsedMultimap);
            } else {
                String firstResource = (String)inUsedResourceNames.iterator().next();
                throw new ResourceInUsedException(firstResource, inUsedMultimap.get((Object)firstResource));
            }
        }
    }

    private void checkResourceNameNotInUseIgnoreSingleTableRule(Collection<String> inUsedResourceNames, Multimap<String, String> inUsedMultimap) throws DistSQLException {
        for (String each : inUsedResourceNames) {
            Collection inUsedRules = inUsedMultimap.get((Object)each);
            inUsedRules.remove(SingleTableRule.class.getSimpleName());
            DistSQLException.predictionThrow((boolean)inUsedRules.isEmpty(), () -> new ResourceInUsedException(each, inUsedRules));
        }
    }

    private Multimap<String, String> getInUsedResources(String databaseName) {
        LinkedListMultimap result = LinkedListMultimap.create();
        for (ShardingSphereRule each : ProxyContext.getInstance().getDatabase(databaseName).getRuleMetaData().getRules()) {
            Collection<String> inUsedResourceNames;
            if (each instanceof DataSourceContainedRule) {
                inUsedResourceNames = this.getInUsedResourceNames((DataSourceContainedRule)each);
                inUsedResourceNames.forEach(arg_0 -> DropResourceBackendHandler.lambda$getInUsedResources$3((Multimap)result, each, arg_0));
            }
            if (!(each instanceof DataNodeContainedRule)) continue;
            inUsedResourceNames = this.getInUsedResourceNames((DataNodeContainedRule)each);
            inUsedResourceNames.forEach(arg_0 -> DropResourceBackendHandler.lambda$getInUsedResources$4((Multimap)result, each, arg_0));
        }
        return result;
    }

    private Collection<String> getInUsedResourceNames(DataSourceContainedRule rule) {
        HashSet<String> result = new HashSet<String>();
        for (Collection each : rule.getDataSourceMapper().values()) {
            result.addAll(each);
        }
        return result;
    }

    private Collection<String> getInUsedResourceNames(DataNodeContainedRule rule) {
        HashSet<String> result = new HashSet<String>();
        for (Collection each : rule.getAllDataNodes().values()) {
            result.addAll(each.stream().map(DataNode::getDataSourceName).collect(Collectors.toList()));
        }
        return result;
    }

    private static /* synthetic */ void lambda$getInUsedResources$4(Multimap result, ShardingSphereRule each, String eachResource) {
        result.put((Object)eachResource, (Object)each.getType());
    }

    private static /* synthetic */ void lambda$getInUsedResources$3(Multimap result, ShardingSphereRule each, String eachResource) {
        result.put((Object)eachResource, (Object)each.getType());
    }
}

